/*
 * Decompiled with CFR 0.152.
 */
package com.janus.easyqrinvoice.gui;

import com.janus.easyqrinvoice.EasyQRInvoiceGenerator;
import com.janus.easyqrinvoice.InvoiceDataVO;
import com.janus.easyqrinvoice.gui.ApplicationContext;
import com.janus.easyqrinvoice.gui.EasyQRInvoice;
import com.janus.easyqrinvoice.gui.EasyQRInvoicePreferences;
import com.janus.easyqrinvoice.gui.EasyQRInvoiceVerificationStateCallback;
import com.janus.easyqrinvoice.gui.ErrorMessages;
import com.janus.easyqrinvoice.gui.FieldType;
import com.janus.easyqrinvoice.gui.Styles;
import com.janus.easyqrinvoice.verifier.ConditionalNotNullAmountVerifier;
import com.janus.easyqrinvoice.verifier.ConditionalNotNullTextVerifier;
import com.janus.easyqrinvoice.verifier.MaxLengthVerifier;
import com.janus.easyqrinvoice.verifier.NotNullBICVerifier;
import com.janus.easyqrinvoice.verifier.NotNullIBANVerifier;
import com.janus.easyqrinvoice.verifier.NotNullKontoinhaberVerifier;
import com.janus.easyqrinvoice.verifier.NotNullPositionVerifier;
import com.janus.easyqrinvoice.verifier.SaveOnlyVerifier;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;

public class MainPanel
extends JPanel {
    public static final String LAST_OPEN_DIR = "last.open.dir";
    private static final long serialVersionUID = 9827349827349L;
    protected Logger logger = Logger.getLogger(MainPanel.class.getName());
    protected StyledDocument centerTextPanelDocument;
    protected Styles logPanelStyle;
    private final JButton uploadBtn = new JButton();
    private final JButton downloadBtn = new JButton();
    private JLabel kontoinhaberLabel;
    private JTextField kontoinhaberField;
    private JLabel ibanLabel;
    private JTextField ibanField;
    private JLabel bicLabel;
    private JTextField bicField;
    private JLabel fixedAmountAndInformationOptionLabel;
    protected JRadioButton fixedAmountAndInformationOption;
    private JLabel fixedAmountLabel;
    private JTextField fixedAmountField;
    private JLabel fixedInformationLabel;
    private JTextField fixedInformationField;
    private JLabel amountAndInformationFromFileOptionLabel;
    protected JRadioButton amountAndInformationFromFileOption;
    private ButtonGroup amountAndInformationOptionGroup;
    private JLabel amountSearchStringLabel;
    private JTextField amountSearchStringField;
    private JLabel informationSearchStringLabel;
    private JTextField informationSearchStringField;
    private JLabel newPageDocumentOptionLabel;
    protected JRadioButton newDocumentOption;
    private JLabel newPageOptionLabel;
    protected JRadioButton newPageOption;
    private JLabel existingPageOptionLabel;
    protected JRadioButton existingPageOption;
    private ButtonGroup newAndExistingPageOptionGroup;
    private JLabel positionXLabel;
    private JTextField positionXField;
    private JLabel positionYLabel;
    private JTextField positionYField;
    private JLabel pageNoLabel;
    private JTextField pageNoField;
    private JLabel textLabel;
    private JTextField textField;
    private JLabel doBackupLabel;
    private JCheckBox doBackupCheckbox;
    private JLabel printInsteadOfSaveLabel;
    private JCheckBox printInsteadOfSaveCheckbox;
    private JLabel openAfterSavingLabel;
    private JCheckBox openAfterSavingCheckbox;
    private JLabel sizeLabel;
    private JTextField sizeField;
    private ErrorMessages errorMessages;
    private JLabel errorLabel;
    private JButton openManual;
    private JButton openSupportEMail;
    private final EasyQRInvoiceVerificationStateCallback callbackUpload;
    private final EasyQRInvoiceVerificationStateCallback callbackDownload;
    EasyQRInvoicePreferences preferences = new EasyQRInvoicePreferences();

    public MainPanel(StyledDocument styledDocument) {
        this.centerTextPanelDocument = styledDocument;
        this.callbackUpload = new EasyQRInvoiceVerificationStateCallback(this.uploadBtn);
        this.callbackDownload = new EasyQRInvoiceVerificationStateCallback(this.downloadBtn);
        this.logPanelStyle = new Styles(this.centerTextPanelDocument);
        this.init();
    }

    protected void doOpenFileDialog() {
        Object object;
        this.logger.finest("+doOpenFileDialog");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(ApplicationContext.get().text().getString("selectFile"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        EasyQRInvoicePreferences easyQRInvoicePreferences = new EasyQRInvoicePreferences();
        String string = easyQRInvoicePreferences.loadPreference(LAST_OPEN_DIR);
        if (string != null && ((File)(object = new File(string))).exists()) {
            jFileChooser.setCurrentDirectory((File)object);
        }
        object = new FileNameExtensionFilter("pdf", "pdf");
        jFileChooser.addChoosableFileFilter((FileFilter)object);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(true);
        int n = jFileChooser.showDialog(null, ApplicationContext.get().text().getString("importFile"));
        switch (n) {
            case 0: {
                easyQRInvoicePreferences.savePreference(LAST_OPEN_DIR, jFileChooser.getCurrentDirectory().toString());
                this.doOpenFile(jFileChooser.getSelectedFiles());
                break;
            }
            case 1: {
                this.logger.fine("Cancel pressed.");
                jFileChooser.setVisible(false);
                break;
            }
        }
        this.logger.finest("-doOpenFileDialog");
    }

    protected void doSaveFileDialog() {
        this.logger.finest("+doSaveFileDialog");
        if (!this.printInsteadOfSaveCheckbox.isSelected()) {
            Object object;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogType(1);
            jFileChooser.setDialogTitle(ApplicationContext.get().text().getString("selectFile"));
            EasyQRInvoicePreferences easyQRInvoicePreferences = new EasyQRInvoicePreferences();
            String string = easyQRInvoicePreferences.loadPreference(LAST_OPEN_DIR);
            if (string != null && ((File)(object = new File(string))).exists()) {
                jFileChooser.setCurrentDirectory((File)object);
            }
            object = new FileNameExtensionFilter("pdf", "pdf");
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("jpg", "jpg");
            jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
            jFileChooser.addChoosableFileFilter((FileFilter)object);
            jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
            jFileChooser.setFileFilter((FileFilter)object);
            int n = jFileChooser.showDialog(null, ApplicationContext.get().text().getString("createFile"));
            switch (n) {
                case 0: {
                    easyQRInvoicePreferences.savePreference(LAST_OPEN_DIR, jFileChooser.getCurrentDirectory().toString());
                    this.doSaveFile(jFileChooser.getSelectedFile(), jFileChooser.getFileFilter() != null ? jFileChooser.getFileFilter().getDescription() : null);
                    break;
                }
                case 1: {
                    this.logger.fine("Cancel pressed.");
                    jFileChooser.setVisible(false);
                    break;
                }
            }
        } else {
            this.doSaveFile(new File("dummy"), null);
        }
        this.logger.finest("-doSaveFileDialog");
    }

    protected void writeLogLine(String string, Style style) throws BadLocationException {
        this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), string, style);
        if (!style.getName().contains("icon")) {
            this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "\n", style);
        }
    }

    public void addFirstSteps() {
        try {
            this.writeLogLine("-------------------------------", this.logPanelStyle.getRegularStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("firstSteps.step1"), this.logPanelStyle.getRegularStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("firstSteps.step2"), this.logPanelStyle.getRegularStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("firstSteps.step3"), this.logPanelStyle.getRegularStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("firstSteps.step4"), this.logPanelStyle.getRegularStyle());
            this.writeLogLine("-------------------------------", this.logPanelStyle.getRegularStyle());
        }
        catch (BadLocationException badLocationException) {
            this.logger.log(Level.SEVERE, "Exception while printing log lines.", badLocationException);
        }
    }

    protected static JPopupMenu getCopyCutPasteMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        jMenuItem.setText(ApplicationContext.get().text().getString("cut"));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        jMenuItem.setText(ApplicationContext.get().text().getString("copy"));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        jMenuItem.setText(ApplicationContext.get().text().getString("paste"));
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    private void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{28, 28, 28, 28, 0};
        gridBagLayout.rowHeights = new int[]{28, 28, 28, 28, 0, 28, 28, 28};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 1.0, 0.0, 0.0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.setLayout(gridBagLayout);
        this.kontoinhaberLabel = new JLabel(ApplicationContext.get().text().getString("accountHolder"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.kontoinhaberLabel, gridBagConstraints);
        this.kontoinhaberField = new JTextField();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        this.add((Component)this.kontoinhaberField, gridBagConstraints2);
        this.kontoinhaberField.setColumns(10);
        this.kontoinhaberField.setText(this.preferences.loadPreference(FieldType.KONTOINHABER.name()));
        this.kontoinhaberField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        this.ibanLabel = new JLabel(ApplicationContext.get().text().getString("iban"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 1;
        this.add((Component)this.ibanLabel, gridBagConstraints3);
        this.ibanField = new JTextField();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 11;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 1;
        this.add((Component)this.ibanField, gridBagConstraints4);
        this.ibanField.setColumns(10);
        this.ibanField.setText(this.preferences.loadPreference(FieldType.IBAN.name()));
        this.ibanField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        this.bicLabel = new JLabel(ApplicationContext.get().text().getString("bic"));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.anchor = 13;
        gridBagConstraints5.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 2;
        this.add((Component)this.bicLabel, gridBagConstraints5);
        this.bicField = new JTextField();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.anchor = 11;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints6.gridx = 2;
        gridBagConstraints6.gridy = 2;
        this.add((Component)this.bicField, gridBagConstraints6);
        this.bicField.setColumns(10);
        this.bicField.setText(this.preferences.loadPreference(FieldType.BIC.name()));
        this.bicField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        this.fixedAmountAndInformationOptionLabel = new JLabel(ApplicationContext.get().text().getString("fixedAmountAndInformation"));
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.anchor = 13;
        gridBagConstraints7.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints7.gridx = 1;
        gridBagConstraints7.gridy = 3;
        this.add((Component)this.fixedAmountAndInformationOptionLabel, gridBagConstraints7);
        this.fixedAmountAndInformationOption = new JRadioButton();
        this.fixedAmountAndInformationOption.setSelected(this.preferences.loadPreference(FieldType.FIXED_AMOUNT_AND_INFORMATION.name(), true));
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.gridx = 2;
        gridBagConstraints8.gridy = 3;
        this.add((Component)this.fixedAmountAndInformationOption, gridBagConstraints8);
        this.fixedAmountAndInformationOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainPanel.this.fixedAmountAndInformationOption.isSelected()) {
                    MainPanel.this.preferences.savePreference(FieldType.FIXED_AMOUNT_AND_INFORMATION.name(), String.valueOf(true));
                    MainPanel.this.amountAndInformationFromFileOption.setSelected(false);
                    MainPanel.this.preferences.savePreference(FieldType.AMOUNT_AND_INFORMATION_FROM_FILE.name(), String.valueOf(false));
                    MainPanel.this.fixedAmountField.setEnabled(true);
                    MainPanel.this.fixedInformationField.setEnabled(true);
                    MainPanel.this.amountSearchStringField.setEnabled(false);
                    MainPanel.this.informationSearchStringField.setEnabled(false);
                    MainPanel.this.fixedAmountField.getInputVerifier().verify(MainPanel.this.fixedAmountField);
                    MainPanel.this.fixedInformationField.getInputVerifier().verify(MainPanel.this.fixedInformationField);
                    MainPanel.this.amountSearchStringField.getInputVerifier().verify(MainPanel.this.amountSearchStringField);
                    MainPanel.this.informationSearchStringField.getInputVerifier().verify(MainPanel.this.informationSearchStringField);
                    MainPanel.this.callbackDownload.setExternalVerification(MainPanel.this.newDocumentOption.isSelected());
                    MainPanel.this.callbackUpload.setExternalVerification(true);
                }
            }
        });
        this.fixedAmountLabel = new JLabel(ApplicationContext.get().text().getString("fixedAmount"));
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.anchor = 13;
        gridBagConstraints9.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints9.gridx = 1;
        gridBagConstraints9.gridy = 4;
        this.add((Component)this.fixedAmountLabel, gridBagConstraints9);
        this.fixedAmountField = new JTextField();
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.anchor = 11;
        gridBagConstraints10.fill = 2;
        gridBagConstraints10.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints10.gridx = 2;
        gridBagConstraints10.gridy = 4;
        this.add((Component)this.fixedAmountField, gridBagConstraints10);
        this.fixedAmountField.setColumns(10);
        this.fixedAmountField.setText(this.preferences.loadPreference(FieldType.FIXED_AMOUNT.name(), ApplicationContext.get().text().getString("betrag")));
        this.fixedAmountField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        this.fixedInformationLabel = new JLabel(ApplicationContext.get().text().getString("fixedInformation"));
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.anchor = 13;
        gridBagConstraints11.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints11.gridx = 1;
        gridBagConstraints11.gridy = 5;
        this.add((Component)this.fixedInformationLabel, gridBagConstraints11);
        this.fixedInformationField = new JTextField();
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.anchor = 11;
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints12.gridx = 2;
        gridBagConstraints12.gridy = 5;
        this.add((Component)this.fixedInformationField, gridBagConstraints12);
        this.fixedInformationField.setColumns(10);
        this.fixedInformationField.setText(this.preferences.loadPreference(FieldType.FIXED_INFORMATION.name(), ApplicationContext.get().text().getString("verwendungszweck")));
        this.fixedInformationField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        this.amountAndInformationFromFileOptionLabel = new JLabel(ApplicationContext.get().text().getString("amountAndInformationFromFile"));
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.anchor = 13;
        gridBagConstraints13.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints13.gridx = 1;
        gridBagConstraints13.gridy = 6;
        this.add((Component)this.amountAndInformationFromFileOptionLabel, gridBagConstraints13);
        this.amountAndInformationFromFileOption = new JRadioButton();
        this.amountAndInformationFromFileOption.setSelected(this.preferences.loadPreference(FieldType.AMOUNT_AND_INFORMATION_FROM_FILE.name(), false));
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints14.fill = 2;
        gridBagConstraints14.gridx = 2;
        gridBagConstraints14.gridy = 6;
        this.add((Component)this.amountAndInformationFromFileOption, gridBagConstraints14);
        this.amountAndInformationFromFileOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainPanel.this.amountAndInformationFromFileOption.isSelected()) {
                    MainPanel.this.preferences.savePreference(FieldType.AMOUNT_AND_INFORMATION_FROM_FILE.name(), String.valueOf(true));
                    MainPanel.this.fixedAmountAndInformationOption.setSelected(false);
                    MainPanel.this.preferences.savePreference(FieldType.FIXED_AMOUNT_AND_INFORMATION.name(), String.valueOf(false));
                    MainPanel.this.fixedAmountField.setEnabled(false);
                    MainPanel.this.fixedInformationField.setEnabled(false);
                    MainPanel.this.amountSearchStringField.setEnabled(true);
                    MainPanel.this.informationSearchStringField.setEnabled(true);
                    MainPanel.this.fixedAmountField.getInputVerifier().verify(MainPanel.this.fixedAmountField);
                    MainPanel.this.fixedInformationField.getInputVerifier().verify(MainPanel.this.fixedInformationField);
                    MainPanel.this.amountSearchStringField.getInputVerifier().verify(MainPanel.this.amountSearchStringField);
                    MainPanel.this.informationSearchStringField.getInputVerifier().verify(MainPanel.this.informationSearchStringField);
                    MainPanel.this.callbackDownload.setExternalVerification(false);
                    MainPanel.this.callbackUpload.setExternalVerification(true);
                }
            }
        });
        this.amountSearchStringLabel = new JLabel(ApplicationContext.get().text().getString("amountSearchString"));
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.anchor = 13;
        gridBagConstraints15.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints15.gridx = 1;
        gridBagConstraints15.gridy = 7;
        this.add((Component)this.amountSearchStringLabel, gridBagConstraints15);
        this.amountSearchStringField = new JTextField();
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.anchor = 11;
        gridBagConstraints16.fill = 2;
        gridBagConstraints16.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints16.gridx = 2;
        gridBagConstraints16.gridy = 7;
        this.add((Component)this.amountSearchStringField, gridBagConstraints16);
        this.amountSearchStringField.setColumns(10);
        this.amountSearchStringField.setText(this.preferences.loadPreference(FieldType.AMOUNT_SEARCH_STRING.name(), "Summe"));
        this.amountSearchStringField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        this.informationSearchStringLabel = new JLabel(ApplicationContext.get().text().getString("informationSearchString"));
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.anchor = 13;
        gridBagConstraints17.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints17.gridx = 1;
        gridBagConstraints17.gridy = 8;
        this.add((Component)this.informationSearchStringLabel, gridBagConstraints17);
        this.informationSearchStringField = new JTextField();
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.anchor = 11;
        gridBagConstraints18.fill = 2;
        gridBagConstraints18.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints18.gridx = 2;
        gridBagConstraints18.gridy = 8;
        this.add((Component)this.informationSearchStringField, gridBagConstraints18);
        this.informationSearchStringField.setColumns(10);
        this.informationSearchStringField.setText(this.preferences.loadPreference(FieldType.INFORMATION_SEARCH_STRING.name(), "Rechnungs-Nr.:"));
        this.informationSearchStringField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        this.amountAndInformationOptionGroup = new ButtonGroup();
        this.amountAndInformationOptionGroup.add(this.fixedAmountAndInformationOption);
        this.amountAndInformationOptionGroup.add(this.amountAndInformationFromFileOption);
        this.newPageDocumentOptionLabel = new JLabel(ApplicationContext.get().text().getString("newDocument"));
        GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
        gridBagConstraints19.anchor = 13;
        gridBagConstraints19.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints19.gridx = 1;
        gridBagConstraints19.gridy = 9;
        this.add((Component)this.newPageDocumentOptionLabel, gridBagConstraints19);
        this.newDocumentOption = new JRadioButton();
        this.newDocumentOption.setSelected(this.preferences.loadPreference(FieldType.NEW_DOCUMENT.name(), true));
        GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
        gridBagConstraints20.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints20.fill = 2;
        gridBagConstraints20.gridx = 2;
        gridBagConstraints20.gridy = 9;
        this.add((Component)this.newDocumentOption, gridBagConstraints20);
        this.newDocumentOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainPanel.this.newDocumentOption.isSelected()) {
                    MainPanel.this.preferences.savePreference(FieldType.NEW_DOCUMENT.name(), String.valueOf(true));
                    MainPanel.this.newPageOption.setSelected(false);
                    MainPanel.this.preferences.savePreference(FieldType.NEW_PAGE.name(), String.valueOf(false));
                    MainPanel.this.existingPageOption.setSelected(false);
                    MainPanel.this.preferences.savePreference(FieldType.EXISTING_PAGE.name(), String.valueOf(false));
                    MainPanel.this.positionXField.setEnabled(false);
                    MainPanel.this.positionYField.setEnabled(false);
                    MainPanel.this.pageNoField.setEnabled(false);
                    MainPanel.this.doBackupCheckbox.setEnabled(false);
                    MainPanel.this.positionXField.getInputVerifier().verify(MainPanel.this.positionXField);
                    MainPanel.this.positionYField.getInputVerifier().verify(MainPanel.this.positionYField);
                    MainPanel.this.pageNoField.getInputVerifier().verify(MainPanel.this.pageNoField);
                    MainPanel.this.doBackupCheckbox.getInputVerifier().verify(MainPanel.this.doBackupCheckbox);
                    MainPanel.this.callbackUpload.setExternalVerification(true);
                    MainPanel.this.callbackDownload.setExternalVerification(MainPanel.this.fixedAmountAndInformationOption.isSelected());
                }
            }
        });
        this.newPageOptionLabel = new JLabel(ApplicationContext.get().text().getString("newPage"));
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.anchor = 13;
        gridBagConstraints21.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints21.gridx = 1;
        gridBagConstraints21.gridy = 10;
        this.add((Component)this.newPageOptionLabel, gridBagConstraints21);
        this.newPageOption = new JRadioButton();
        this.newPageOption.setSelected(this.preferences.loadPreference(FieldType.NEW_PAGE.name(), false));
        GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
        gridBagConstraints22.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints22.fill = 2;
        gridBagConstraints22.gridx = 2;
        gridBagConstraints22.gridy = 10;
        this.add((Component)this.newPageOption, gridBagConstraints22);
        this.newPageOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainPanel.this.newPageOption.isSelected()) {
                    MainPanel.this.preferences.savePreference(FieldType.NEW_PAGE.name(), String.valueOf(true));
                    MainPanel.this.newDocumentOption.setSelected(false);
                    MainPanel.this.preferences.savePreference(FieldType.NEW_DOCUMENT.name(), String.valueOf(false));
                    MainPanel.this.existingPageOption.setSelected(false);
                    MainPanel.this.preferences.savePreference(FieldType.EXISTING_PAGE.name(), String.valueOf(false));
                    MainPanel.this.positionXField.setEnabled(false);
                    MainPanel.this.positionYField.setEnabled(false);
                    MainPanel.this.pageNoField.setEnabled(false);
                    MainPanel.this.doBackupCheckbox.setEnabled(true);
                    MainPanel.this.positionXField.getInputVerifier().verify(MainPanel.this.positionXField);
                    MainPanel.this.positionYField.getInputVerifier().verify(MainPanel.this.positionYField);
                    MainPanel.this.pageNoField.getInputVerifier().verify(MainPanel.this.pageNoField);
                    MainPanel.this.doBackupCheckbox.getInputVerifier().verify(MainPanel.this.doBackupCheckbox);
                    MainPanel.this.callbackUpload.setExternalVerification(true);
                    MainPanel.this.callbackDownload.setExternalVerification(false);
                }
            }
        });
        this.existingPageOptionLabel = new JLabel(ApplicationContext.get().text().getString("existingPage"));
        GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
        gridBagConstraints23.anchor = 13;
        gridBagConstraints23.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints23.gridx = 1;
        gridBagConstraints23.gridy = 11;
        this.add((Component)this.existingPageOptionLabel, gridBagConstraints23);
        this.existingPageOption = new JRadioButton();
        this.existingPageOption.setSelected(this.preferences.loadPreference(FieldType.EXISTING_PAGE.name(), false));
        GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
        gridBagConstraints24.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints24.fill = 2;
        gridBagConstraints24.gridx = 2;
        gridBagConstraints24.gridy = 11;
        this.add((Component)this.existingPageOption, gridBagConstraints24);
        this.existingPageOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainPanel.this.existingPageOption.isSelected()) {
                    MainPanel.this.preferences.savePreference(FieldType.EXISTING_PAGE.name(), String.valueOf(true));
                    MainPanel.this.newDocumentOption.setSelected(false);
                    MainPanel.this.preferences.savePreference(FieldType.NEW_DOCUMENT.name(), String.valueOf(false));
                    MainPanel.this.newPageOption.setSelected(false);
                    MainPanel.this.preferences.savePreference(FieldType.NEW_PAGE.name(), String.valueOf(false));
                    MainPanel.this.positionXField.setEnabled(true);
                    MainPanel.this.positionYField.setEnabled(true);
                    MainPanel.this.pageNoField.setEnabled(true);
                    MainPanel.this.doBackupCheckbox.setEnabled(true);
                    MainPanel.this.positionXField.getInputVerifier().verify(MainPanel.this.positionXField);
                    MainPanel.this.positionYField.getInputVerifier().verify(MainPanel.this.positionYField);
                    MainPanel.this.pageNoField.getInputVerifier().verify(MainPanel.this.pageNoField);
                    MainPanel.this.doBackupCheckbox.getInputVerifier().verify(MainPanel.this.doBackupCheckbox);
                    MainPanel.this.callbackUpload.setExternalVerification(true);
                    MainPanel.this.callbackDownload.setExternalVerification(false);
                }
            }
        });
        this.newAndExistingPageOptionGroup = new ButtonGroup();
        this.newAndExistingPageOptionGroup.add(this.newPageOption);
        this.newAndExistingPageOptionGroup.add(this.existingPageOption);
        this.newAndExistingPageOptionGroup.add(this.newDocumentOption);
        this.positionXLabel = new JLabel(ApplicationContext.get().text().getString("positionx"));
        this.positionXLabel.setToolTipText(ApplicationContext.get().text().getString("positionXTooltip"));
        GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
        gridBagConstraints25.anchor = 13;
        gridBagConstraints25.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints25.gridx = 1;
        gridBagConstraints25.gridy = 12;
        this.add((Component)this.positionXLabel, gridBagConstraints25);
        this.positionXField = new JTextField();
        this.positionXField.setToolTipText(ApplicationContext.get().text().getString("positionXTooltip"));
        GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
        gridBagConstraints26.anchor = 11;
        gridBagConstraints26.fill = 2;
        gridBagConstraints26.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints26.gridx = 2;
        gridBagConstraints26.gridy = 12;
        this.add((Component)this.positionXField, gridBagConstraints26);
        this.positionXField.setColumns(5);
        this.positionXField.setText(this.preferences.loadPreference(FieldType.POSITION_X.name(), ApplicationContext.get().text().getString("posX")));
        this.positionXField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        this.positionYLabel = new JLabel(ApplicationContext.get().text().getString("positiony"));
        this.positionYLabel.setToolTipText(ApplicationContext.get().text().getString("positionYTooltip"));
        GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
        gridBagConstraints27.anchor = 13;
        gridBagConstraints27.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints27.gridx = 1;
        gridBagConstraints27.gridy = 13;
        this.add((Component)this.positionYLabel, gridBagConstraints27);
        this.positionYField = new JTextField();
        this.positionYField.setToolTipText(ApplicationContext.get().text().getString("positionYTooltip"));
        GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
        gridBagConstraints28.anchor = 11;
        gridBagConstraints28.fill = 2;
        gridBagConstraints28.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints28.gridx = 2;
        gridBagConstraints28.gridy = 13;
        this.add((Component)this.positionYField, gridBagConstraints28);
        this.positionYField.setColumns(5);
        this.positionYField.setText(this.preferences.loadPreference(FieldType.POSITION_Y.name(), ApplicationContext.get().text().getString("posY")));
        this.positionYField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        this.pageNoLabel = new JLabel(ApplicationContext.get().text().getString("pageNumber"));
        GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
        gridBagConstraints29.anchor = 13;
        gridBagConstraints29.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints29.gridx = 1;
        gridBagConstraints29.gridy = 14;
        this.add((Component)this.pageNoLabel, gridBagConstraints29);
        this.pageNoField = new JTextField();
        GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
        gridBagConstraints30.anchor = 11;
        gridBagConstraints30.fill = 2;
        gridBagConstraints30.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints30.gridx = 2;
        gridBagConstraints30.gridy = 14;
        this.add((Component)this.pageNoField, gridBagConstraints30);
        this.pageNoField.setColumns(5);
        this.pageNoField.setText(this.preferences.loadPreference(FieldType.PAGE_NO.name(), ApplicationContext.get().text().getString("pageNo")));
        this.pageNoField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        this.textLabel = new JLabel(ApplicationContext.get().text().getString("qrCodeText"));
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.anchor = 13;
        gridBagConstraints31.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints31.gridx = 1;
        gridBagConstraints31.gridy = 15;
        this.add((Component)this.textLabel, gridBagConstraints31);
        this.textField = new JTextField();
        GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
        gridBagConstraints32.anchor = 11;
        gridBagConstraints32.fill = 2;
        gridBagConstraints32.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints32.gridx = 2;
        gridBagConstraints32.gridy = 15;
        this.add((Component)this.textField, gridBagConstraints32);
        this.textField.setColumns(5);
        this.textField.setText(this.preferences.loadPreference(FieldType.TEXT.name(), ApplicationContext.get().text().getString("text")));
        this.textField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        this.doBackupLabel = new JLabel(ApplicationContext.get().text().getString("doBackup"));
        GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
        gridBagConstraints33.anchor = 13;
        gridBagConstraints33.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints33.gridx = 1;
        gridBagConstraints33.gridy = 16;
        this.add((Component)this.doBackupLabel, gridBagConstraints33);
        this.doBackupCheckbox = new JCheckBox();
        this.doBackupCheckbox.setSelected(this.preferences.loadPreference(FieldType.DO_BACKUP.name(), true));
        GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
        gridBagConstraints34.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints34.fill = 2;
        gridBagConstraints34.gridx = 2;
        gridBagConstraints34.gridy = 16;
        this.add((Component)this.doBackupCheckbox, gridBagConstraints34);
        this.printInsteadOfSaveLabel = new JLabel(ApplicationContext.get().text().getString("printInsteadOfSave"));
        GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
        gridBagConstraints35.anchor = 13;
        gridBagConstraints35.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints35.gridx = 1;
        gridBagConstraints35.gridy = 17;
        this.add((Component)this.printInsteadOfSaveLabel, gridBagConstraints35);
        this.printInsteadOfSaveCheckbox = new JCheckBox();
        this.printInsteadOfSaveCheckbox.setSelected(this.preferences.loadPreference(FieldType.PRINT_INSTEAD_OF_SAVE.name(), false));
        GridBagConstraints gridBagConstraints36 = new GridBagConstraints();
        gridBagConstraints36.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints36.fill = 2;
        gridBagConstraints36.gridx = 2;
        gridBagConstraints36.gridy = 17;
        this.add((Component)this.printInsteadOfSaveCheckbox, gridBagConstraints36);
        this.openAfterSavingLabel = new JLabel(ApplicationContext.get().text().getString("openAfterSaving"));
        GridBagConstraints gridBagConstraints37 = new GridBagConstraints();
        gridBagConstraints37.anchor = 13;
        gridBagConstraints37.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints37.gridx = 1;
        gridBagConstraints37.gridy = 18;
        this.add((Component)this.openAfterSavingLabel, gridBagConstraints37);
        this.openAfterSavingCheckbox = new JCheckBox();
        this.openAfterSavingCheckbox.setSelected(this.preferences.loadPreference(FieldType.OPEN_AFTER_SAVING.name(), false));
        GridBagConstraints gridBagConstraints38 = new GridBagConstraints();
        gridBagConstraints38.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints38.fill = 2;
        gridBagConstraints38.gridx = 2;
        gridBagConstraints38.gridy = 18;
        this.add((Component)this.openAfterSavingCheckbox, gridBagConstraints38);
        this.sizeLabel = new JLabel(ApplicationContext.get().text().getString("size"));
        this.sizeLabel.setToolTipText(ApplicationContext.get().text().getString("sizeTooltip"));
        GridBagConstraints gridBagConstraints39 = new GridBagConstraints();
        gridBagConstraints39.anchor = 13;
        gridBagConstraints39.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints39.gridx = 1;
        gridBagConstraints39.gridy = 19;
        this.add((Component)this.sizeLabel, gridBagConstraints39);
        this.sizeField = new JTextField();
        this.sizeField.setToolTipText(ApplicationContext.get().text().getString("sizeTooltip"));
        GridBagConstraints gridBagConstraints40 = new GridBagConstraints();
        gridBagConstraints40.anchor = 11;
        gridBagConstraints40.fill = 2;
        gridBagConstraints40.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints40.gridx = 2;
        gridBagConstraints40.gridy = 19;
        this.add((Component)this.sizeField, gridBagConstraints40);
        this.sizeField.setColumns(5);
        this.sizeField.setText(this.preferences.loadPreference(FieldType.SIZE.name(), ApplicationContext.get().text().getString("sizeDefault")));
        this.sizeField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        this.uploadBtn.setText(ApplicationContext.get().text().getString("selectFile"));
        GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
        gridBagConstraints41.anchor = 18;
        gridBagConstraints41.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints41.gridx = 2;
        gridBagConstraints41.gridy = 20;
        this.add((Component)this.uploadBtn, gridBagConstraints41);
        this.uploadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.doOpenFileDialog();
            }
        });
        this.downloadBtn.setText(ApplicationContext.get().text().getString("saveAsFile"));
        GridBagConstraints gridBagConstraints42 = new GridBagConstraints();
        gridBagConstraints42.anchor = 18;
        gridBagConstraints42.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints42.gridx = 2;
        gridBagConstraints42.gridy = 21;
        this.add((Component)this.downloadBtn, gridBagConstraints42);
        this.downloadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.doSaveFileDialog();
            }
        });
        this.openManual = new JButton(ApplicationContext.get().text().getString("openManual"));
        this.openManual.setToolTipText(ApplicationContext.get().text().getString("openManualTooltip"));
        GridBagConstraints gridBagConstraints43 = new GridBagConstraints();
        gridBagConstraints43.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints43.fill = 2;
        gridBagConstraints43.gridx = 3;
        gridBagConstraints43.gridy = 20;
        this.add((Component)this.openManual, gridBagConstraints43);
        this.openManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    EasyQRInvoice.openWebpage(new URL(ApplicationContext.get().text().getString("manualURL")).toURI());
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    MainPanel.this.logger.log(Level.WARNING, "Could not open connection to " + ApplicationContext.get().text().getString("manualURL"), exception);
                }
            }
        });
        this.openSupportEMail = new JButton(ApplicationContext.get().text().getString("openSupportEMail"));
        this.openSupportEMail.setToolTipText(ApplicationContext.get().text().getString("openSupportEMailTooltip"));
        GridBagConstraints gridBagConstraints44 = new GridBagConstraints();
        gridBagConstraints44.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints44.fill = 2;
        gridBagConstraints44.gridx = 3;
        gridBagConstraints44.gridy = 21;
        this.add((Component)this.openSupportEMail, gridBagConstraints44);
        this.openSupportEMail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    EasyQRInvoice.openWebpage(new URL(ApplicationContext.get().text().getString("supportEMailURL")).toURI());
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    MainPanel.this.logger.log(Level.WARNING, "Could not open connection to " + ApplicationContext.get().text().getString("supportEMailURL"), exception);
                }
            }
        });
        this.errorLabel = new JLabel("");
        GridBagConstraints gridBagConstraints45 = new GridBagConstraints();
        gridBagConstraints45.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints45.gridx = 2;
        gridBagConstraints45.gridy = 22;
        this.add((Component)this.errorLabel, gridBagConstraints45);
        this.errorMessages = new ErrorMessages(this.errorLabel);
        NotNullKontoinhaberVerifier notNullKontoinhaberVerifier = new NotNullKontoinhaberVerifier(this.kontoinhaberField, FieldType.KONTOINHABER, this.errorMessages, this.callbackUpload, this.callbackDownload);
        NotNullIBANVerifier notNullIBANVerifier = new NotNullIBANVerifier(this.ibanField, FieldType.IBAN, this.errorMessages, this.callbackUpload, this.callbackDownload);
        NotNullBICVerifier notNullBICVerifier = new NotNullBICVerifier(this.bicField, FieldType.BIC, this.errorMessages, this.callbackUpload, this.callbackDownload);
        SaveOnlyVerifier saveOnlyVerifier = new SaveOnlyVerifier(this.fixedAmountAndInformationOption, FieldType.FIXED_AMOUNT_AND_INFORMATION);
        ConditionalNotNullAmountVerifier conditionalNotNullAmountVerifier = new ConditionalNotNullAmountVerifier((JComponent)this.fixedAmountField, FieldType.FIXED_AMOUNT, this.errorMessages, this.fixedAmountAndInformationOption, this.callbackUpload, this.callbackDownload);
        ConditionalNotNullTextVerifier conditionalNotNullTextVerifier = new ConditionalNotNullTextVerifier((JComponent)this.fixedInformationField, FieldType.FIXED_INFORMATION, this.errorMessages, this.fixedAmountAndInformationOption, this.callbackUpload, this.callbackDownload);
        SaveOnlyVerifier saveOnlyVerifier2 = new SaveOnlyVerifier(this.amountAndInformationFromFileOption, FieldType.AMOUNT_AND_INFORMATION_FROM_FILE);
        ConditionalNotNullTextVerifier conditionalNotNullTextVerifier2 = new ConditionalNotNullTextVerifier((JComponent)this.amountSearchStringField, FieldType.AMOUNT_SEARCH_STRING, this.errorMessages, this.fixedAmountAndInformationOption, this.callbackUpload, this.callbackDownload);
        ConditionalNotNullTextVerifier conditionalNotNullTextVerifier3 = new ConditionalNotNullTextVerifier((JComponent)this.informationSearchStringField, FieldType.INFORMATION_SEARCH_STRING, this.errorMessages, this.fixedAmountAndInformationOption, this.callbackUpload, this.callbackDownload);
        SaveOnlyVerifier saveOnlyVerifier3 = new SaveOnlyVerifier(this.newDocumentOption, FieldType.NEW_DOCUMENT);
        SaveOnlyVerifier saveOnlyVerifier4 = new SaveOnlyVerifier(this.newPageOption, FieldType.NEW_PAGE);
        SaveOnlyVerifier saveOnlyVerifier5 = new SaveOnlyVerifier(this.existingPageOption, FieldType.EXISTING_PAGE);
        NotNullPositionVerifier notNullPositionVerifier = new NotNullPositionVerifier(this.positionXField, FieldType.POSITION_X, this.errorMessages, this.callbackUpload, this.callbackDownload);
        NotNullPositionVerifier notNullPositionVerifier2 = new NotNullPositionVerifier(this.positionYField, FieldType.POSITION_Y, this.errorMessages, this.callbackUpload, this.callbackDownload);
        NotNullPositionVerifier notNullPositionVerifier3 = new NotNullPositionVerifier(this.pageNoField, FieldType.PAGE_NO, this.errorMessages, this.callbackUpload, this.callbackDownload);
        MaxLengthVerifier maxLengthVerifier = new MaxLengthVerifier(this.textField, FieldType.TEXT, this.errorMessages, 20, this.callbackUpload, this.callbackDownload);
        SaveOnlyVerifier saveOnlyVerifier6 = new SaveOnlyVerifier(this.doBackupCheckbox, FieldType.DO_BACKUP);
        SaveOnlyVerifier saveOnlyVerifier7 = new SaveOnlyVerifier(this.printInsteadOfSaveCheckbox, FieldType.PRINT_INSTEAD_OF_SAVE);
        SaveOnlyVerifier saveOnlyVerifier8 = new SaveOnlyVerifier(this.openAfterSavingCheckbox, FieldType.OPEN_AFTER_SAVING);
        NotNullPositionVerifier notNullPositionVerifier4 = new NotNullPositionVerifier(this.sizeField, FieldType.SIZE, this.errorMessages, this.callbackUpload, this.callbackDownload);
        this.kontoinhaberField.setInputVerifier(notNullKontoinhaberVerifier);
        this.ibanField.setInputVerifier(notNullIBANVerifier);
        this.bicField.setInputVerifier(notNullBICVerifier);
        this.fixedAmountAndInformationOption.setInputVerifier(saveOnlyVerifier);
        this.fixedAmountField.setInputVerifier(conditionalNotNullAmountVerifier);
        this.fixedInformationField.setInputVerifier(conditionalNotNullTextVerifier);
        this.amountAndInformationFromFileOption.setInputVerifier(saveOnlyVerifier2);
        this.amountSearchStringField.setInputVerifier(conditionalNotNullTextVerifier2);
        this.informationSearchStringField.setInputVerifier(conditionalNotNullTextVerifier3);
        this.newDocumentOption.setInputVerifier(saveOnlyVerifier3);
        this.newPageOption.setInputVerifier(saveOnlyVerifier4);
        this.existingPageOption.setInputVerifier(saveOnlyVerifier5);
        this.positionXField.setInputVerifier(notNullPositionVerifier);
        this.positionYField.setInputVerifier(notNullPositionVerifier2);
        this.pageNoField.setInputVerifier(notNullPositionVerifier3);
        this.textField.setInputVerifier(maxLengthVerifier);
        this.doBackupCheckbox.setInputVerifier(saveOnlyVerifier6);
        this.printInsteadOfSaveCheckbox.setInputVerifier(saveOnlyVerifier7);
        this.openAfterSavingCheckbox.setInputVerifier(saveOnlyVerifier8);
        this.sizeField.setInputVerifier(notNullPositionVerifier4);
        ((InputVerifier)notNullKontoinhaberVerifier).verify(this.kontoinhaberField);
        ((InputVerifier)notNullIBANVerifier).verify(this.ibanField);
        ((InputVerifier)notNullBICVerifier).verify(this.bicField);
        ((InputVerifier)saveOnlyVerifier).verify(this.fixedAmountAndInformationOption);
        ((InputVerifier)conditionalNotNullAmountVerifier).verify(this.fixedAmountField);
        ((InputVerifier)conditionalNotNullTextVerifier).verify(this.fixedInformationField);
        ((InputVerifier)saveOnlyVerifier2).verify(this.amountAndInformationFromFileOption);
        ((InputVerifier)conditionalNotNullTextVerifier2).verify(this.amountSearchStringField);
        ((InputVerifier)conditionalNotNullTextVerifier3).verify(this.informationSearchStringField);
        ((InputVerifier)saveOnlyVerifier3).verify(this.newDocumentOption);
        ((InputVerifier)saveOnlyVerifier4).verify(this.newPageOption);
        ((InputVerifier)saveOnlyVerifier5).verify(this.existingPageOption);
        ((InputVerifier)notNullPositionVerifier).verify(this.positionXField);
        ((InputVerifier)notNullPositionVerifier2).verify(this.positionYField);
        ((InputVerifier)notNullPositionVerifier3).verify(this.pageNoField);
        ((InputVerifier)maxLengthVerifier).verify(this.textField);
        ((InputVerifier)saveOnlyVerifier6).verify(this.doBackupCheckbox);
        ((InputVerifier)saveOnlyVerifier7).verify(this.printInsteadOfSaveCheckbox);
        ((InputVerifier)saveOnlyVerifier8).verify(this.openAfterSavingCheckbox);
        ((InputVerifier)notNullPositionVerifier4).verify(this.sizeField);
        if (this.fixedAmountAndInformationOption.isSelected()) {
            this.fixedAmountField.setEnabled(true);
            this.fixedInformationField.setEnabled(true);
            this.amountSearchStringField.setEnabled(false);
            this.informationSearchStringField.setEnabled(false);
            ((InputVerifier)conditionalNotNullAmountVerifier).verify(this.fixedAmountField);
            ((InputVerifier)conditionalNotNullTextVerifier).verify(this.fixedInformationField);
        }
        if (this.amountAndInformationFromFileOption.isSelected()) {
            this.fixedAmountField.setEnabled(false);
            this.fixedInformationField.setEnabled(false);
            this.amountSearchStringField.setEnabled(true);
            this.informationSearchStringField.setEnabled(true);
            ((InputVerifier)conditionalNotNullTextVerifier2).verify(this.amountSearchStringField);
            ((InputVerifier)conditionalNotNullTextVerifier3).verify(this.informationSearchStringField);
        }
        if (this.newDocumentOption.isSelected() || this.newPageOption.isSelected()) {
            this.positionXField.setEnabled(false);
            this.positionYField.setEnabled(false);
            this.pageNoField.setEnabled(false);
            this.positionXField.getInputVerifier().verify(this.positionXField);
            this.positionYField.getInputVerifier().verify(this.positionYField);
            this.pageNoField.getInputVerifier().verify(this.pageNoField);
        }
        if (this.existingPageOption.isSelected()) {
            this.positionXField.setEnabled(true);
            this.positionYField.setEnabled(true);
            this.pageNoField.setEnabled(true);
            this.positionXField.getInputVerifier().verify(this.positionXField);
            this.positionYField.getInputVerifier().verify(this.positionYField);
            this.pageNoField.getInputVerifier().verify(this.pageNoField);
        }
        this.callbackUpload.setExternalVerification(true);
        this.callbackDownload.setExternalVerification(this.newDocumentOption.isSelected() && this.fixedAmountAndInformationOption.isSelected());
    }

    protected void doOpenFile(File[] fileArray) {
        this.logger.finest("+doOpenFile");
        try {
            this.writeLogLine("-------------------------------", this.logPanelStyle.getRegularStyle());
            if (fileArray != null && fileArray.length > 0) {
                EasyQRInvoiceGenerator easyQRInvoiceGenerator = new EasyQRInvoiceGenerator();
                int n = 0;
                int n2 = 0;
                for (File file : fileArray) {
                    try {
                        Object object;
                        this.writeLogLine("---", this.logPanelStyle.getRegularStyle());
                        if (this.doBackupCheckbox.isSelected() && !this.newDocumentOption.isSelected()) {
                            object = this.preferences.loadPreference("BACKUP_SUFFIX", ".save");
                            File file2 = new File(file.getAbsoluteFile() + (String)object);
                            Files.copy(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            this.writeLogLine(ApplicationContext.get().text().getString("backupFileCreated") + ": " + file2.getAbsolutePath(), this.logPanelStyle.getIconSaveStyle());
                            this.writeLogLine(ApplicationContext.get().text().getString("backupFileCreated") + ": " + file2.getAbsolutePath(), this.logPanelStyle.getRegularStyle());
                        }
                        if (this.fixedAmountAndInformationOption.isSelected()) {
                            object = new DecimalFormat();
                            ((DecimalFormat)object).setParseBigDecimal(true);
                            easyQRInvoiceGenerator.addQRCodeToInvoice(file.getAbsolutePath(), (BigDecimal)((NumberFormat)object).parse(this.fixedAmountField.getText()), this.fixedInformationField.getText(), this.kontoinhaberField.getText(), this.ibanField.getText(), this.bicField.getText(), this.newDocumentOption.isSelected(), this.newPageOption.isSelected(), new Integer(this.positionXField.getText()).intValue(), new Integer(this.positionYField.getText()).intValue(), new Integer(this.pageNoField.getText()), this.textField.getText(), this.printInsteadOfSaveCheckbox.isSelected(), this.openAfterSavingCheckbox.isSelected(), true, new Integer(this.sizeField.getText()), false);
                        }
                        if (this.amountAndInformationFromFileOption.isSelected()) {
                            object = easyQRInvoiceGenerator.addQRCodeToInvoice(file.getAbsolutePath(), this.amountSearchStringField.getText(), this.informationSearchStringField.getText(), this.kontoinhaberField.getText(), this.ibanField.getText(), this.bicField.getText(), this.newDocumentOption.isSelected(), this.newPageOption.isSelected(), new Integer(this.positionXField.getText()).intValue(), new Integer(this.positionYField.getText()).intValue(), new Integer(this.pageNoField.getText()), this.textField.getText(), this.printInsteadOfSaveCheckbox.isSelected(), this.openAfterSavingCheckbox.isSelected(), true, new Integer(this.sizeField.getText()));
                            if (((InvoiceDataVO)object).amount == null || ((InvoiceDataVO)object).amount.isEmpty()) {
                                this.writeLogLine(file.getAbsolutePath(), this.logPanelStyle.getIconWarningStyle());
                                this.writeLogLine(ApplicationContext.get().text().getString("amountEmpty"), this.logPanelStyle.getRegularStyle());
                            } else if (this.isNoAmount(((InvoiceDataVO)object).amount)) {
                                this.writeLogLine(file.getAbsolutePath(), this.logPanelStyle.getIconWarningStyle());
                                this.writeLogLine(MessageFormat.format(ApplicationContext.get().text().getString("amountNotANumber"), ((InvoiceDataVO)object).amount), this.logPanelStyle.getRegularStyle());
                            } else {
                                this.writeLogLine(file.getAbsolutePath(), this.logPanelStyle.getIconOkStyle());
                                this.writeLogLine(ApplicationContext.get().text().getString("amount") + ": " + ((InvoiceDataVO)object).amount, this.logPanelStyle.getRegularStyle());
                            }
                            if (((InvoiceDataVO)object).reference == null || ((InvoiceDataVO)object).reference.isEmpty()) {
                                this.writeLogLine(file.getAbsolutePath(), this.logPanelStyle.getIconWarningStyle());
                                this.writeLogLine(ApplicationContext.get().text().getString("referenceEmpty"), this.logPanelStyle.getRegularStyle());
                            } else {
                                this.writeLogLine(file.getAbsolutePath(), this.logPanelStyle.getIconOkStyle());
                                this.writeLogLine(ApplicationContext.get().text().getString("reference") + ": " + ((InvoiceDataVO)object).reference, this.logPanelStyle.getRegularStyle());
                            }
                        }
                        this.writeLogLine(file.getAbsolutePath(), this.logPanelStyle.getIconOkStyle());
                        if (!this.printInsteadOfSaveCheckbox.isSelected()) {
                            this.writeLogLine(ApplicationContext.get().text().getString("qrCodeAdded") + ": " + file.getAbsolutePath(), this.logPanelStyle.getRegularStyle());
                        } else {
                            this.writeLogLine(ApplicationContext.get().text().getString("qrCodePrinted"), this.logPanelStyle.getRegularStyle());
                        }
                        ++n;
                    }
                    catch (Exception exception) {
                        this.logger.log(Level.SEVERE, "Exception while saving file.", exception);
                        this.writeLogLine(file.getAbsolutePath(), this.logPanelStyle.getIconErrorStyle());
                        if (!this.printInsteadOfSaveCheckbox.isSelected()) {
                            this.writeLogLine(ApplicationContext.get().text().getString("qrCodeNotAdded") + ": " + file.getAbsolutePath(), this.logPanelStyle.getRegularStyle());
                        } else {
                            this.writeLogLine(ApplicationContext.get().text().getString("qrCodeNotPrinted"), this.logPanelStyle.getRegularStyle());
                        }
                        ++n2;
                    }
                }
                this.writeLogLine("---", this.logPanelStyle.getRegularStyle());
                this.writeLogLine(ApplicationContext.get().text().getString("numberOfFilesSuccessfull") + ": " + n, this.logPanelStyle.getRegularStyle());
                this.writeLogLine(ApplicationContext.get().text().getString("numberOfFilesError") + ": " + n2, this.logPanelStyle.getRegularStyle());
            } else {
                this.writeLogLine(ApplicationContext.get().text().getString("noFileSelected"), this.logPanelStyle.getIconErrorStyle());
                this.writeLogLine(ApplicationContext.get().text().getString("noFileSelected"), this.logPanelStyle.getRegularStyle());
            }
            this.writeLogLine("-------------------------------", this.logPanelStyle.getRegularStyle());
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "Exception while saving files.", exception);
            try {
                this.writeLogLine(ApplicationContext.get().text().getString("unknowException"), this.logPanelStyle.getIconErrorStyle());
                this.writeLogLine(exception.getMessage(), this.logPanelStyle.getRegularStyle());
            }
            catch (BadLocationException badLocationException) {
                this.logger.log(Level.SEVERE, "Exception while writing log line.", badLocationException);
            }
        }
        this.logger.finest("-doOpenFile");
    }

    protected void doSaveFile(File file, String string) {
        this.logger.finest("+doSaveFile");
        try {
            this.writeLogLine("-------------------------------", this.logPanelStyle.getRegularStyle());
            File file2 = file;
            if (!file2.getAbsolutePath().toLowerCase().endsWith(".pdf") && !file2.getAbsolutePath().toLowerCase().endsWith(".jpg")) {
                if (string != null) {
                    file2 = new File(file.getAbsolutePath() + "." + string);
                    this.logger.fine("adding file extension \"." + string + "\"");
                } else {
                    file2 = new File(file.getAbsolutePath() + ".pdf");
                    this.logger.fine("adding file extension \".pdf\"");
                }
            }
            if (file != null) {
                EasyQRInvoiceGenerator easyQRInvoiceGenerator = new EasyQRInvoiceGenerator();
                try {
                    this.writeLogLine("---", this.logPanelStyle.getRegularStyle());
                    DecimalFormat decimalFormat = new DecimalFormat();
                    decimalFormat.setParseBigDecimal(true);
                    easyQRInvoiceGenerator.addQRCodeToInvoice(file2.getAbsolutePath(), (BigDecimal)decimalFormat.parse(this.fixedAmountField.getText()), this.fixedInformationField.getText(), this.kontoinhaberField.getText(), this.ibanField.getText(), this.bicField.getText(), this.newDocumentOption.isSelected(), this.newPageOption.isSelected(), new Integer(this.positionXField.getText()).intValue(), new Integer(this.positionYField.getText()).intValue(), new Integer(this.pageNoField.getText()), this.textField.getText(), this.printInsteadOfSaveCheckbox.isSelected(), this.openAfterSavingCheckbox.isSelected(), false, new Integer(this.sizeField.getText()), file2.getAbsolutePath().toLowerCase().endsWith(".jpg"));
                    this.writeLogLine(file2.getAbsolutePath(), this.logPanelStyle.getIconOkStyle());
                    if (!this.printInsteadOfSaveCheckbox.isSelected()) {
                        this.writeLogLine(ApplicationContext.get().text().getString("qrCodeCreated") + ": " + file2.getAbsolutePath(), this.logPanelStyle.getRegularStyle());
                    } else {
                        this.writeLogLine(ApplicationContext.get().text().getString("qrCodePrinted"), this.logPanelStyle.getRegularStyle());
                    }
                }
                catch (Exception exception) {
                    this.logger.log(Level.SEVERE, "Exception while saving file.", exception);
                    this.writeLogLine(file2.getAbsolutePath(), this.logPanelStyle.getIconErrorStyle());
                    if (!this.printInsteadOfSaveCheckbox.isSelected()) {
                        this.writeLogLine(ApplicationContext.get().text().getString("qrCodeNotCreated") + ": " + file2.getAbsolutePath(), this.logPanelStyle.getRegularStyle());
                    }
                    this.writeLogLine(ApplicationContext.get().text().getString("qrCodeNotPrinted"), this.logPanelStyle.getRegularStyle());
                }
                this.writeLogLine("---", this.logPanelStyle.getRegularStyle());
            } else {
                this.writeLogLine(ApplicationContext.get().text().getString("noFileSelected"), this.logPanelStyle.getIconErrorStyle());
                this.writeLogLine(ApplicationContext.get().text().getString("noFileSelected"), this.logPanelStyle.getRegularStyle());
            }
            this.writeLogLine("-------------------------------", this.logPanelStyle.getRegularStyle());
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "Exception while saving files.", exception);
            try {
                this.writeLogLine(ApplicationContext.get().text().getString("unknowException"), this.logPanelStyle.getIconErrorStyle());
                this.writeLogLine(exception.getMessage(), this.logPanelStyle.getRegularStyle());
            }
            catch (BadLocationException badLocationException) {
                this.logger.log(Level.SEVERE, "Exception while writing log line.", badLocationException);
            }
        }
        this.logger.finest("-doSaveFile");
    }

    private boolean isNoAmount(String string) {
        String string2 = string;
        string2 = string2.replace(" ", "");
        string2 = string2.replace(".", "");
        string2 = string2.replace(",", "");
        try {
            Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
        return false;
    }
}

