/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.c14n.implementations;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.helper.C14nHelper;
import com.sun.org.apache.xml.internal.security.c14n.implementations.CanonicalizerBase;
import com.sun.org.apache.xml.internal.security.c14n.implementations.NameSpaceSymbTable;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class Canonicalizer20010315
extends CanonicalizerBase {
    private static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final String XML_LANG_URI = "http://www.w3.org/XML/1998/namespace";
    private boolean firstCall = true;
    private final SortedSet<Attr> result = new TreeSet<Attr>(COMPARE);
    private XmlAttrStack xmlattrStack = new XmlAttrStack();

    public Canonicalizer20010315(boolean bl) {
        super(bl);
    }

    @Override
    public byte[] engineCanonicalizeXPathNodeSet(Set<Node> set, String string) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }

    @Override
    public byte[] engineCanonicalizeSubTree(Node node, String string) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }

    @Override
    protected Iterator<Attr> handleAttributesSubtree(Element element, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException {
        if (!element.hasAttributes() && !this.firstCall) {
            return null;
        }
        SortedSet<Attr> sortedSet = this.result;
        sortedSet.clear();
        if (element.hasAttributes()) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Node node;
                Attr attr = (Attr)namedNodeMap.item(i);
                String string = attr.getNamespaceURI();
                String string2 = attr.getLocalName();
                String string3 = attr.getValue();
                if (!XMLNS_URI.equals(string)) {
                    sortedSet.add(attr);
                    continue;
                }
                if ("xml".equals(string2) && XML_LANG_URI.equals(string3) || (node = nameSpaceSymbTable.addMappingAndRender(string2, string3, attr)) == null) continue;
                sortedSet.add((Attr)node);
                if (!C14nHelper.namespaceIsRelative(attr)) continue;
                Object[] objectArray = new Object[]{element.getTagName(), string2, attr.getNodeValue()};
                throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
            }
        }
        if (this.firstCall) {
            nameSpaceSymbTable.getUnrenderedNodes(sortedSet);
            this.xmlattrStack.getXmlnsAttr(sortedSet);
            this.firstCall = false;
        }
        return sortedSet.iterator();
    }

    @Override
    protected Iterator<Attr> handleAttributes(Element element, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException {
        Object object;
        this.xmlattrStack.push(nameSpaceSymbTable.getLevel());
        boolean bl = this.isVisibleDO(element, nameSpaceSymbTable.getLevel()) == 1;
        SortedSet<Attr> sortedSet = this.result;
        sortedSet.clear();
        if (element.hasAttributes()) {
            object = element.getAttributes();
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)object.item(i);
                String string = attr.getNamespaceURI();
                String string2 = attr.getLocalName();
                String string3 = attr.getValue();
                if (!XMLNS_URI.equals(string)) {
                    if (XML_LANG_URI.equals(string)) {
                        this.xmlattrStack.addXmlnsAttr(attr);
                        continue;
                    }
                    if (!bl) continue;
                    sortedSet.add(attr);
                    continue;
                }
                if ("xml".equals(string2) && XML_LANG_URI.equals(string3)) continue;
                if (this.isVisible(attr)) {
                    Node node;
                    if (!bl && nameSpaceSymbTable.removeMappingIfRender(string2) || (node = nameSpaceSymbTable.addMappingAndRender(string2, string3, attr)) == null) continue;
                    sortedSet.add((Attr)node);
                    if (!C14nHelper.namespaceIsRelative(attr)) continue;
                    Object[] objectArray = new Object[]{element.getTagName(), string2, attr.getNodeValue()};
                    throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
                }
                if (bl && !"xmlns".equals(string2)) {
                    nameSpaceSymbTable.removeMapping(string2);
                    continue;
                }
                nameSpaceSymbTable.addMapping(string2, string3, attr);
            }
        }
        if (bl) {
            object = element.getAttributeNodeNS(XMLNS_URI, "xmlns");
            Node node = null;
            if (object == null) {
                node = nameSpaceSymbTable.getMapping("xmlns");
            } else if (!this.isVisible((Node)object)) {
                node = nameSpaceSymbTable.addMappingAndRender("xmlns", "", this.getNullNode(object.getOwnerDocument()));
            }
            if (node != null) {
                sortedSet.add((Attr)node);
            }
            this.xmlattrStack.getXmlnsAttr(sortedSet);
            nameSpaceSymbTable.getUnrenderedNodes(sortedSet);
        }
        return sortedSet.iterator();
    }

    @Override
    protected void circumventBugIfNeeded(XMLSignatureInput xMLSignatureInput) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException {
        if (!xMLSignatureInput.isNeedsToBeExpanded()) {
            return;
        }
        Document document = null;
        document = xMLSignatureInput.getSubNode() != null ? XMLUtils.getOwnerDocument(xMLSignatureInput.getSubNode()) : XMLUtils.getOwnerDocument(xMLSignatureInput.getNodeSet());
        XMLUtils.circumventBug2650(document);
    }

    @Override
    protected void handleParent(Element element, NameSpaceSymbTable nameSpaceSymbTable) {
        Object object;
        String string;
        Object object2;
        if (!element.hasAttributes() && element.getNamespaceURI() == null) {
            return;
        }
        this.xmlattrStack.push(-1);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            object2 = (Attr)namedNodeMap.item(i);
            string = object2.getLocalName();
            object = object2.getNodeValue();
            if (XMLNS_URI.equals(object2.getNamespaceURI())) {
                if ("xml".equals(string) && XML_LANG_URI.equals(object)) continue;
                nameSpaceSymbTable.addMapping(string, (String)object, (Attr)object2);
                continue;
            }
            if (!XML_LANG_URI.equals(object2.getNamespaceURI())) continue;
            this.xmlattrStack.addXmlnsAttr((Attr)object2);
        }
        if (element.getNamespaceURI() != null) {
            String string2 = element.getPrefix();
            object2 = element.getNamespaceURI();
            if (string2 == null || string2.equals("")) {
                string2 = "xmlns";
                string = "xmlns";
            } else {
                string = "xmlns:" + string2;
            }
            object = element.getOwnerDocument().createAttributeNS(XMLNS_URI, string);
            object.setValue((String)object2);
            nameSpaceSymbTable.addMapping(string2, (String)object2, (Attr)object);
        }
    }

    private static class XmlAttrStack {
        int currentLevel = 0;
        int lastlevel = 0;
        XmlsStackElement cur;
        List<XmlsStackElement> levels = new ArrayList<XmlsStackElement>();

        private XmlAttrStack() {
        }

        void push(int n) {
            this.currentLevel = n;
            if (this.currentLevel == -1) {
                return;
            }
            this.cur = null;
            while (this.lastlevel >= this.currentLevel) {
                this.levels.remove(this.levels.size() - 1);
                int n2 = this.levels.size();
                if (n2 == 0) {
                    this.lastlevel = 0;
                    return;
                }
                this.lastlevel = this.levels.get((int)(n2 - 1)).level;
            }
        }

        void addXmlnsAttr(Attr attr) {
            if (this.cur == null) {
                this.cur = new XmlsStackElement();
                this.cur.level = this.currentLevel;
                this.levels.add(this.cur);
                this.lastlevel = this.currentLevel;
            }
            this.cur.nodes.add(attr);
        }

        void getXmlnsAttr(Collection<Attr> collection) {
            int n = this.levels.size() - 1;
            if (this.cur == null) {
                this.cur = new XmlsStackElement();
                this.cur.level = this.currentLevel;
                this.lastlevel = this.currentLevel;
                this.levels.add(this.cur);
            }
            boolean bl = false;
            XmlsStackElement xmlsStackElement = null;
            if (n == -1) {
                bl = true;
            } else {
                xmlsStackElement = this.levels.get(n);
                if (xmlsStackElement.rendered && xmlsStackElement.level + 1 == this.currentLevel) {
                    bl = true;
                }
            }
            if (bl) {
                collection.addAll(this.cur.nodes);
                this.cur.rendered = true;
                return;
            }
            HashMap<String, Attr> hashMap = new HashMap<String, Attr>();
            while (n >= 0) {
                xmlsStackElement = this.levels.get(n);
                for (Attr attr : xmlsStackElement.nodes) {
                    if (hashMap.containsKey(attr.getName())) continue;
                    hashMap.put(attr.getName(), attr);
                }
                --n;
            }
            this.cur.rendered = true;
            collection.addAll(hashMap.values());
        }

        static class XmlsStackElement {
            int level;
            boolean rendered = false;
            List<Attr> nodes = new ArrayList<Attr>();

            XmlsStackElement() {
            }
        }
    }
}

