/*
 * Decompiled with CFR 0.152.
 */
package com.janus.easyqrinvoice.verifier;

import com.janus.easyqrinvoice.gui.ErrorMessages;
import com.janus.easyqrinvoice.gui.FieldType;
import com.janus.easyqrinvoice.gui.VerificationStateCallback;
import com.janus.easyqrinvoice.validator.EasyQRInvoiceValidator;
import com.janus.easyqrinvoice.validator.ValidationException;
import com.janus.easyqrinvoice.verifier.NotNullVerifier;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public class ConditionalNotNullTextVerifier
extends NotNullVerifier {
    private final JRadioButton conditional;

    public ConditionalNotNullTextVerifier(JComponent jComponent, FieldType fieldType, ErrorMessages errorMessages, JRadioButton jRadioButton, VerificationStateCallback ... verificationStateCallbackArray) {
        super(jComponent, fieldType, errorMessages, verificationStateCallbackArray);
        this.conditional = jRadioButton;
    }

    @Override
    public boolean verify(JComponent jComponent) {
        boolean bl = true;
        try {
            if (this.conditional.isSelected()) {
                bl = super.verify(jComponent);
                if (bl) {
                    EasyQRInvoiceValidator.validateText(this.txt);
                    this.resetMessage();
                }
            } else {
                super.readValue(jComponent);
                this.resetMessage();
            }
        }
        catch (ValidationException validationException) {
            this.setErrorMessage(validationException.getMessage());
            bl = false;
        }
        super.toggleVerificationState(bl);
        return bl;
    }
}

