/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.colorpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.debugger.colorpane.ColorBarCellRenderer;
import org.apache.pdfbox.debugger.colorpane.DeviceNColorant;
import org.apache.pdfbox.debugger.colorpane.DeviceNTableModel;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;

public class CSDeviceN {
    private final PDDeviceN deviceN;
    private JPanel panel;

    public CSDeviceN(COSArray array) throws IOException {
        this.deviceN = new PDDeviceN(array);
        DeviceNColorant[] colorants = this.getColorantData();
        this.initUI(colorants);
    }

    private DeviceNColorant[] getColorantData() throws IOException {
        int componentCount = this.deviceN.getNumberOfComponents();
        DeviceNColorant[] colorants = new DeviceNColorant[componentCount];
        for (int i = 0; i < componentCount; ++i) {
            DeviceNColorant colorant = new DeviceNColorant();
            colorant.setName(this.deviceN.getColorantNames().get(i));
            float[] maximum = new float[componentCount];
            Arrays.fill(maximum, 0.0f);
            float[] minimum = new float[componentCount];
            Arrays.fill(minimum, 0.0f);
            maximum[i] = 1.0f;
            colorant.setMaximum(this.getColorObj(this.deviceN.toRGB(maximum)));
            colorant.setMinimum(this.getColorObj(this.deviceN.toRGB(minimum)));
            colorants[i] = colorant;
        }
        return colorants;
    }

    private void initUI(DeviceNColorant[] colorants) {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.setPreferredSize(new Dimension(300, 500));
        JLabel colorSpaceLabel = new JLabel("DeviceN colorspace");
        colorSpaceLabel.setAlignmentX(0.5f);
        colorSpaceLabel.setFont(new Font("Monospaced", 1, 30));
        DeviceNTableModel tableModel = new DeviceNTableModel(colorants);
        JTable table = new JTable(tableModel);
        table.setDefaultRenderer(Color.class, new ColorBarCellRenderer());
        table.setRowHeight(60);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(table);
        this.panel.add(colorSpaceLabel);
        this.panel.add(scrollPane);
    }

    public Component getPanel() {
        return this.panel;
    }

    private Color getColorObj(float[] rgbValues) {
        return new Color(rgbValues[0], rgbValues[1], rgbValues[2]);
    }
}

