/*
 * Decompiled with CFR 0.152.
 */
package com.janus.easyqrinvoice;

import com.janus.easyqrinvoice.gui.ApplicationContext;
import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.printing.PDFPageable;

public class InvoiceExtender {
    protected static final int LENGTH_OF_TEXT = 20;
    private static final Logger logger = Logger.getLogger(InvoiceExtender.class.getName());

    public void addPNGAndTextToPDF(String string, BufferedImage bufferedImage, String string2, boolean bl, boolean bl2, String string3, String string4, String string5, String string6, String string7, float f, float f2, int n, boolean bl3, boolean bl4, boolean bl5) throws IOException, PrinterException {
        String string8 = null;
        try (PDDocument pDDocument = null;){
            PDPage pDPage;
            if (bl) {
                pDDocument = new PDDocument();
                string8 = this.getNewDocumentFileName(string, bl5);
            } else {
                string8 = string;
                pDDocument = PDDocument.load(new File(string8));
            }
            float f3 = 0.0f;
            float f4 = 0.0f;
            if (bl || bl2) {
                pDPage = new PDPage(PDRectangle.A4);
                f3 = 20.0f;
                f4 = 645.0f;
                pDDocument.addPage(pDPage);
            } else {
                pDPage = pDDocument.getPage(n - 1);
                f3 = f;
                f4 = f2;
            }
            PDImageXObject pDImageXObject = LosslessFactory.createFromImage(pDDocument, bufferedImage);
            try (PDPageContentStream pDPageContentStream = null;){
                pDPageContentStream = new PDPageContentStream(pDDocument, pDPage, PDPageContentStream.AppendMode.APPEND, true, true);
                pDPageContentStream.drawImage(pDImageXObject, f3, f4, (float)(bufferedImage.getWidth() / 2), (float)(bufferedImage.getHeight() / 2));
                if (string2 != null && !string2.isEmpty()) {
                    pDPageContentStream.beginText();
                    pDPageContentStream.newLineAtOffset(f3 + 10.0f, f4 - 10.0f);
                    pDPageContentStream.setFont(PDType1Font.HELVETICA_BOLD, 13.0f);
                    pDPageContentStream.showText(this.fillBlanksTo20(string2));
                    pDPageContentStream.endText();
                }
                if (bl || bl2) {
                    pDPageContentStream.beginText();
                    pDPageContentStream.setFont(PDType1Font.HELVETICA_BOLD, 11.0f);
                    pDPageContentStream.newLineAtOffset(f3 + 205.0f, f4 + 100.0f);
                    pDPageContentStream.showText(ApplicationContext.get().text().getString("accountHolder") + ": " + string3);
                    pDPageContentStream.endText();
                    pDPageContentStream.beginText();
                    pDPageContentStream.setFont(PDType1Font.HELVETICA_BOLD, 11.0f);
                    pDPageContentStream.newLineAtOffset(f3 + 205.0f, f4 + 85.0f);
                    pDPageContentStream.showText(ApplicationContext.get().text().getString("iban") + ": " + string4);
                    pDPageContentStream.endText();
                    pDPageContentStream.beginText();
                    pDPageContentStream.setFont(PDType1Font.HELVETICA_BOLD, 11.0f);
                    pDPageContentStream.newLineAtOffset(f3 + 205.0f, f4 + 70.0f);
                    pDPageContentStream.showText(ApplicationContext.get().text().getString("bic") + ": " + string5);
                    pDPageContentStream.endText();
                    pDPageContentStream.beginText();
                    pDPageContentStream.setFont(PDType1Font.HELVETICA_BOLD, 11.0f);
                    pDPageContentStream.newLineAtOffset(f3 + 205.0f, f4 + 55.0f);
                    pDPageContentStream.showText(ApplicationContext.get().text().getString("amount") + ": " + (string6 != null ? string6 : ""));
                    pDPageContentStream.endText();
                    pDPageContentStream.beginText();
                    pDPageContentStream.setFont(PDType1Font.HELVETICA_BOLD, 11.0f);
                    pDPageContentStream.newLineAtOffset(f3 + 205.0f, f4 + 40.0f);
                    pDPageContentStream.showText(ApplicationContext.get().text().getString("reference") + ": " + (string7 != null ? string7 : ""));
                    pDPageContentStream.endText();
                }
            }
            if (bl3) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                PrintService printService = InvoiceExtender.findPrintService("My Windows printer Name");
                if (printService != null) {
                    printerJob.setPrintService(printService);
                }
                printerJob.setPageable(new PDFPageable(pDDocument));
                if (printerJob.printDialog()) {
                    printerJob.print();
                }
            } else {
                pDDocument.save(string8);
                if (bl4) {
                    Desktop desktop;
                    Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                    if (desktop != null && desktop.isSupported(Desktop.Action.OPEN)) {
                        try {
                            desktop.open(new File(string8));
                        }
                        catch (Exception exception) {
                            logger.log(Level.SEVERE, "Could not open pdf.", exception);
                        }
                    }
                }
            }
        }
        logger.info("QRCode added to PDF or printed.");
    }

    private static PrintService findPrintService(String string) {
        PrintService[] printServiceArray;
        for (PrintService printService : printServiceArray = PrintServiceLookup.lookupPrintServices(null, null)) {
            if (printService.getName().trim().equals(string)) {
                return printService;
            }
            logger.info("Found print service: " + printService.getName());
        }
        return printServiceArray.length > 0 ? printServiceArray[0] : null;
    }

    protected String fillBlanksTo20(String string) {
        if (string.length() == 20) {
            return string;
        }
        String string2 = string;
        int n = 20 - string.length();
        for (int i = 0; i < n / 2; ++i) {
            string2 = " " + string2 + " ";
        }
        if (string2.length() < 20) {
            string2 = " " + string2;
        }
        return string2;
    }

    protected String getNewDocumentFileName(String string, boolean bl) {
        String[] stringArray = string.split("\\.");
        String string2 = "";
        if (bl) {
            string2 = "_QR";
        }
        if ("pdf".equals(stringArray[stringArray.length - 1].toLowerCase())) {
            String string3 = "";
            for (int i = 0; i < stringArray.length - 1; ++i) {
                string3 = string3 + (string3.isEmpty() ? stringArray[i] : "." + stringArray[i]);
            }
            string3 = string3 + string2 + ".pdf";
            return string3;
        }
        return string + string2;
    }
}

