/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.colorpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.debugger.colorpane.ColorBarCellRenderer;
import org.apache.pdfbox.debugger.colorpane.IndexedColorant;
import org.apache.pdfbox.debugger.colorpane.IndexedTableModel;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;

public class CSIndexed {
    private final PDIndexed indexed;
    private JPanel panel;
    private final int colorCount;

    public CSIndexed(COSArray array) throws IOException {
        this.indexed = new PDIndexed(array);
        this.colorCount = this.getHival(array) + 1;
        this.initUI(this.getColorantData());
    }

    private IndexedColorant[] getColorantData() {
        IndexedColorant[] colorants = new IndexedColorant[this.colorCount];
        for (int i = 0; i < this.colorCount; ++i) {
            IndexedColorant colorant = new IndexedColorant();
            colorant.setIndex(i);
            float[] rgbValues = this.indexed.toRGB(new float[]{i});
            colorant.setRgbValues(rgbValues);
            colorants[i] = colorant;
        }
        return colorants;
    }

    private void initUI(IndexedColorant[] colorants) {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.panel.setPreferredSize(new Dimension(300, 500));
        JLabel colorSpaceLabel = new JLabel("Indexed colorspace");
        colorSpaceLabel.setAlignmentX(0.5f);
        colorSpaceLabel.setFont(new Font("Monospaced", 1, 30));
        JPanel colorspaceLabelPanel = new JPanel();
        colorspaceLabelPanel.setAlignmentX(0.0f);
        colorspaceLabelPanel.add(colorSpaceLabel);
        JLabel colorCountLabel = new JLabel(" Total Color Count: " + this.colorCount);
        colorCountLabel.setAlignmentX(0.0f);
        colorCountLabel.setFont(new Font("Monospaced", 1, 20));
        IndexedTableModel tableModel = new IndexedTableModel(colorants);
        JTable table = new JTable(tableModel);
        table.setDefaultRenderer(Color.class, new ColorBarCellRenderer());
        table.setRowHeight(40);
        table.getColumnModel().getColumn(0).setMinWidth(30);
        table.getColumnModel().getColumn(0).setMaxWidth(50);
        table.getColumnModel().getColumn(1).setMinWidth(100);
        table.getColumnModel().getColumn(1).setMaxWidth(100);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(table);
        scrollPane.setAlignmentX(0.0f);
        Box box = Box.createVerticalBox();
        box.add(colorCountLabel);
        box.add(scrollPane);
        box.setAlignmentX(0.0f);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 0.05;
        gbc.fill = 2;
        gbc.anchor = 19;
        this.panel.add((Component)colorspaceLabelPanel, gbc);
        gbc.gridy = 2;
        gbc.weighty = 0.9;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.anchor = 1792;
        this.panel.add((Component)box, gbc);
    }

    public Component getPanel() {
        return this.panel;
    }

    private int getHival(COSArray array) {
        int hival = ((COSNumber)array.getObject(2).getCOSObject()).intValue();
        return Math.min(hival, 255);
    }
}

