/*
 * Decompiled with CFR 0.152.
 */
package com.janus.easyqrinvoice.gui;

import com.janus.easyqrinvoice.gui.FieldType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;

public class ErrorMessages {
    private final Map<FieldType, String> errorMessages = new HashMap<FieldType, String>();
    private final Map<FieldType, String> warningMessages = new HashMap<FieldType, String>();
    private final JLabel errorLabel;

    public ErrorMessages(JLabel jLabel) {
        this.errorLabel = jLabel;
    }

    public void addErrorMessage(String string, FieldType fieldType) {
        this.errorMessages.put(fieldType, string);
        this.refreshErrorLabel();
    }

    public void addWarningMessage(String string, FieldType fieldType) {
        this.warningMessages.put(fieldType, string);
        this.refreshErrorLabel();
    }

    public void removeErrorMessage(FieldType fieldType) {
        this.errorMessages.remove((Object)fieldType);
        this.refreshErrorLabel();
    }

    public void removeWarningMessage(FieldType fieldType) {
        this.warningMessages.remove((Object)fieldType);
        this.refreshErrorLabel();
    }

    protected void refreshErrorLabel() {
        String string = "";
        this.errorLabel.setForeground(Color.black);
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object2 : this.warningMessages.values()) {
            if (!arrayList.contains(object2)) {
                if (!bl) {
                    string = string + ", ";
                }
                string = string + object2;
                arrayList.add(object2);
                bl = false;
            }
            this.errorLabel.setForeground(Color.orange);
        }
        boolean bl2 = true;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string2 : this.errorMessages.values()) {
            if (!arrayList2.contains(string2)) {
                if (!bl2) {
                    string = string + ", ";
                }
                string = string + string2;
                arrayList2.add(string2);
                bl2 = false;
            }
            this.errorLabel.setForeground(Color.red);
        }
        this.errorLabel.setText(string);
    }

    public void removeMessages(FieldType fieldType) {
        this.removeErrorMessage(fieldType);
        this.removeWarningMessage(fieldType);
    }
}

