/*
 * Decompiled with CFR 0.152.
 */
package com.janus.easyqrinvoice.verifier;

import com.janus.easyqrinvoice.gui.ApplicationContext;
import com.janus.easyqrinvoice.gui.EasyQRInvoicePreferences;
import com.janus.easyqrinvoice.gui.ErrorMessages;
import com.janus.easyqrinvoice.gui.FieldType;
import com.janus.easyqrinvoice.gui.VerificationStateCallback;
import java.awt.Color;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class MaxLengthVerifier
extends InputVerifier {
    protected JComponent verifiedComponent;
    protected String txt;
    protected FieldType fieldType;
    protected VerificationStateCallback[] callbacks;
    protected Color originalBackgroundColor;
    protected ErrorMessages errorMessages;
    protected int maxLength;

    public MaxLengthVerifier(JComponent jComponent, FieldType fieldType, ErrorMessages errorMessages, int n, VerificationStateCallback ... verificationStateCallbackArray) {
        this.verifiedComponent = jComponent;
        this.fieldType = fieldType;
        this.errorMessages = errorMessages;
        this.maxLength = n;
        this.callbacks = verificationStateCallbackArray;
        this.originalBackgroundColor = jComponent.getBackground();
    }

    @Override
    public boolean shouldYieldFocus(JComponent jComponent) {
        super.shouldYieldFocus(jComponent);
        return true;
    }

    @Override
    public boolean verify(JComponent jComponent) {
        this.readValue(jComponent);
        boolean bl = this.txt != null && this.txt.length() <= this.maxLength;
        String string = ApplicationContext.get().text().getString("inputTooLong");
        this.setErrorMessage(string);
        if (bl) {
            this.resetMessage();
        }
        for (VerificationStateCallback verificationStateCallback : this.callbacks) {
            verificationStateCallback.toggleVerificationState(this.fieldType, bl);
        }
        return bl;
    }

    protected void setErrorMessage(String string) {
        this.verifiedComponent.setBackground(new Color(255, 186, 186));
        this.errorMessages.addErrorMessage(string, this.fieldType);
    }

    protected void setWarningMessage(String string) {
        this.verifiedComponent.setBackground(Color.orange);
        this.errorMessages.addWarningMessage(string, this.fieldType);
    }

    protected void resetMessage() {
        this.verifiedComponent.setBackground(this.originalBackgroundColor);
        this.errorMessages.removeMessages(this.fieldType);
        EasyQRInvoicePreferences easyQRInvoicePreferences = new EasyQRInvoicePreferences();
        easyQRInvoicePreferences.savePreference(this.fieldType.name(), this.txt);
    }

    protected void readValue(JComponent jComponent) {
        if (jComponent instanceof JTextField) {
            JTextField jTextField = (JTextField)jComponent;
            this.txt = jTextField.getText();
        }
    }
}

