/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.panel.CertificatesInfo;
import com.sun.deploy.panel.JHighDPITable;
import com.sun.deploy.panel.ReadOnlyTableModel;
import com.sun.deploy.security.CertUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class CertificateTabPanel
extends JPanel {
    private final JTable certsTable;
    int certLevel;

    CertificateTabPanel(CertificatesInfo certificatesInfo, int n) {
        Serializable serializable2;
        int n2;
        ReadOnlyTableModel readOnlyTableModel;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setOpaque(false);
        this.certLevel = n;
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setAutoscrolls(true);
        Collection collection = certificatesInfo.getTrustedCertificates(n);
        if (collection == null || collection.isEmpty()) {
            readOnlyTableModel = new ReadOnlyTableModel();
        } else {
            readOnlyTableModel = new ReadOnlyTableModel(collection.size());
            n2 = 0;
            for (Serializable serializable2 : collection) {
                readOnlyTableModel.setValueAt(CertUtils.extractSubjectAliasName((X509Certificate)serializable2), n2, 0);
                readOnlyTableModel.setValueAt(CertUtils.extractIssuerAliasName((X509Certificate)serializable2), n2, 1);
                ++n2;
            }
        }
        this.certsTable = new JHighDPITable(readOnlyTableModel);
        this.certsTable.getTableHeader().setFocusable(false);
        this.certsTable.setFillsViewportHeight(true);
        n2 = this.certsTable.getRowHeight();
        Dimension dimension = new Dimension(n2 * 25, n2 * 7);
        this.certsTable.setPreferredScrollableViewportSize(dimension);
        serializable2 = new DefaultTableCellRenderer();
        ((JComponent)serializable2).putClientProperty("html.disable", Boolean.TRUE);
        this.certsTable.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)serializable2));
        this.certsTable.setDragEnabled(false);
        this.certsTable.setColumnSelectionAllowed(false);
        if (collection != null && collection.size() > 0) {
            this.certsTable.setRowSelectionInterval(0, 0);
        }
        jScrollPane.setViewportView(this.certsTable);
        this.add((Component)jScrollPane, "Center");
    }

    void setCertificateTableModel(TableModel tableModel) {
        this.certsTable.setModel(tableModel);
        this.certsTable.setDragEnabled(false);
        if (this.certLevel == 0) {
            this.certsTable.setSelectionMode(2);
        } else {
            this.certsTable.setSelectionMode(0);
        }
        this.certsTable.setColumnSelectionAllowed(false);
        if (tableModel.getRowCount() > 0) {
            this.certsTable.setRowSelectionInterval(0, 0);
        }
        this.certsTable.updateUI();
    }

    public void registerSelectionListener(ListSelectionListener listSelectionListener) {
        if (this.certsTable != null) {
            ListSelectionModel listSelectionModel = this.certsTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(listSelectionListener);
        }
    }

    int getSelectedCertificateTableRow() {
        return this.certsTable.getSelectedRow();
    }

    int[] getSelectedCertificateTableRows() {
        return this.certsTable.getSelectedRows();
    }

    boolean isCertificateSelected() {
        return this.getSelectedCertificateTableRow() != -1;
    }
}

