/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

@InstrumentationTarget(value="java.io.FileOutputStream")
public final class FileOutputStreamRMHooks {
    private final FileDescriptor fd = null;
    private final String path;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;

    public FileOutputStreamRMHooks() {
        this.path = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    private void open(String string, boolean bl) throws FileNotFoundException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = ApproverGroup.FILE_OPEN_GROUP.getApprover(this);
        long l = 0L;
        try {
            l = resourceRequest.request(1L, resourceIdImpl);
            if (l < 1L) {
                throw new FileNotFoundException(string + ": resource limited: too many open files");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(string + ": resource limited: too many open files");
            fileNotFoundException.initCause(resourceRequestDeniedException);
            throw fileNotFoundException;
        }
        ResourceRequest resourceRequest2 = null;
        long l2 = 0L;
        int n = 0;
        try {
            FileDescriptor fileDescriptor = null;
            try {
                fileDescriptor = this.getFD();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            resourceRequest2 = ApproverGroup.FILEDESCRIPTOR_OPEN_GROUP.getApprover(fileDescriptor);
            try {
                l2 = resourceRequest2.request(1L, resourceIdImpl);
                if (l2 < 1L) {
                    throw new FileNotFoundException(string + ": resource limited: too many open file descriptors");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                FileNotFoundException fileNotFoundException = new FileNotFoundException(string + ": resource limited: too many open file descriptors");
                fileNotFoundException.initCause(resourceRequestDeniedException);
                throw fileNotFoundException;
            }
            this.open(string, bl);
            n = 1;
        }
        finally {
            resourceRequest2.request(-(l2 - (long)n), resourceIdImpl);
            resourceRequest.request(-(l - (long)n), resourceIdImpl);
        }
    }

    @InstrumentationMethod
    public final FileDescriptor getFD() throws IOException {
        return this.getFD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public void write(int n) throws IOException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        FileDescriptor fileDescriptor = this.getFD();
        ResourceRequest resourceRequest = fileDescriptor == FileDescriptor.err ? ApproverGroup.STDERR_WRITE_GROUP.getApprover(this) : (fileDescriptor == FileDescriptor.out ? ApproverGroup.STDOUT_WRITE_GROUP.getApprover(this) : ApproverGroup.FILE_WRITE_GROUP.getApprover(this));
        long l = 0L;
        try {
            l = resourceRequest.request(1L, resourceIdImpl);
            if (l < 1L) {
                throw new IOException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n2 = 0;
        try {
            this.write(n);
            n2 = 1;
        }
        finally {
            resourceRequest.request(-(l - (long)n2), resourceIdImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.write(byArray);
            return;
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        FileDescriptor fileDescriptor = this.getFD();
        ResourceRequest resourceRequest = fileDescriptor == FileDescriptor.err ? ApproverGroup.STDERR_WRITE_GROUP.getApprover(this) : (fileDescriptor == FileDescriptor.out ? ApproverGroup.STDOUT_WRITE_GROUP.getApprover(this) : ApproverGroup.FILE_WRITE_GROUP.getApprover(this));
        int n = byArray.length;
        long l = 0L;
        try {
            l = resourceRequest.request(n, resourceIdImpl);
            if (l < (long)n) {
                throw new IOException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n2 = 0;
        try {
            this.write(byArray);
            n2 = n;
        }
        finally {
            resourceRequest.request(-(l - (long)n2), resourceIdImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            this.write(byArray, n, n2);
            return;
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        FileDescriptor fileDescriptor = this.getFD();
        ResourceRequest resourceRequest = fileDescriptor == FileDescriptor.err ? ApproverGroup.STDERR_WRITE_GROUP.getApprover(this) : (fileDescriptor == FileDescriptor.out ? ApproverGroup.STDOUT_WRITE_GROUP.getApprover(this) : ApproverGroup.FILE_WRITE_GROUP.getApprover(this));
        long l = 0L;
        try {
            l = resourceRequest.request(n2, resourceIdImpl);
            if (l < (long)n2) {
                throw new IOException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n3 = 0;
        try {
            this.write(byArray, n, n2);
            n3 = n2;
        }
        finally {
            resourceRequest.request(-(l - (long)n3), resourceIdImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public void close() throws IOException {
        long l;
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
        }
        JavaIOFileDescriptorAccess javaIOFileDescriptorAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
        try {
            l = javaIOFileDescriptorAccess.getHandle(this.fd);
            if (l == -1L) {
                l = javaIOFileDescriptorAccess.get(this.fd);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            l = javaIOFileDescriptorAccess.get(this.fd);
        }
        try {
            this.close();
        }
        finally {
            ResourceRequest resourceRequest;
            long l2;
            try {
                l2 = javaIOFileDescriptorAccess.getHandle(this.fd);
                if (l2 == -1L) {
                    l2 = javaIOFileDescriptorAccess.get(this.fd);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                l2 = javaIOFileDescriptorAccess.get(this.fd);
            }
            ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
            if (l2 != l) {
                resourceRequest = ApproverGroup.FILEDESCRIPTOR_OPEN_GROUP.getApprover(this.fd);
                resourceRequest.request(-1L, resourceIdImpl);
            }
            resourceRequest = ApproverGroup.FILE_OPEN_GROUP.getApprover(this);
            resourceRequest.request(-1L, resourceIdImpl);
        }
    }
}

