/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;

public class ResourceType {
    private static final WeakHashMap<String, ResourceType> types = new WeakHashMap(32);
    public static final ResourceType FILE_OPEN = ResourceType.ofBuiltin("file.open");
    public static final ResourceType FILE_READ = ResourceType.ofBuiltin("file.read");
    public static final ResourceType FILE_WRITE = ResourceType.ofBuiltin("file.write");
    public static final ResourceType STDERR_WRITE = ResourceType.ofBuiltin("stderr.write");
    public static final ResourceType STDIN_READ = ResourceType.ofBuiltin("stdin.read");
    public static final ResourceType STDOUT_WRITE = ResourceType.ofBuiltin("stdout.write");
    public static final ResourceType SOCKET_OPEN = ResourceType.ofBuiltin("socket.open");
    public static final ResourceType SOCKET_READ = ResourceType.ofBuiltin("socket.read");
    public static final ResourceType SOCKET_WRITE = ResourceType.ofBuiltin("socket.write");
    public static final ResourceType DATAGRAM_OPEN = ResourceType.ofBuiltin("datagram.open");
    public static final ResourceType DATAGRAM_RECEIVED = ResourceType.ofBuiltin("datagram.received");
    public static final ResourceType DATAGRAM_SENT = ResourceType.ofBuiltin("datagram.sent");
    public static final ResourceType DATAGRAM_READ = ResourceType.ofBuiltin("datagram.read");
    public static final ResourceType DATAGRAM_WRITE = ResourceType.ofBuiltin("datagram.write");
    public static final ResourceType THREAD_CREATED = ResourceType.ofBuiltin("thread.created");
    public static final ResourceType THREAD_CPU = ResourceType.ofBuiltin("thread.cpu");
    public static final ResourceType HEAP_RETAINED = ResourceType.ofBuiltin("heap.retained");
    public static final ResourceType HEAP_ALLOCATED = ResourceType.ofBuiltin("heap.allocated");
    public static final ResourceType FILEDESCRIPTOR_OPEN = ResourceType.ofBuiltin("filedescriptor.open");
    private final String name;
    private final boolean builtin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceType of(String string2) {
        WeakHashMap<String, ResourceType> weakHashMap = types;
        synchronized (weakHashMap) {
            return types.computeIfAbsent(string2, string -> new ResourceType((String)string, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ResourceType ofBuiltin(String string2) {
        WeakHashMap<String, ResourceType> weakHashMap = types;
        synchronized (weakHashMap) {
            return types.computeIfAbsent(string2, string -> new ResourceType((String)string, true));
        }
    }

    private boolean isBuiltin() {
        return this.builtin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<ResourceType> builtinTypes() {
        WeakHashMap<String, ResourceType> weakHashMap = types;
        synchronized (weakHashMap) {
            HashSet<ResourceType> hashSet = new HashSet<ResourceType>(types.values());
            hashSet.removeIf(resourceType -> !resourceType.isBuiltin());
            return hashSet;
        }
    }

    private ResourceType(String string, boolean bl) {
        this.name = Objects.requireNonNull(string, "name");
        this.builtin = bl;
        if (string.length() == 0) {
            throw new IllegalArgumentException("name must not be empty");
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int n = 5;
        n = 17 * n + Objects.hashCode(this.name);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ResourceType resourceType = (ResourceType)object;
        return Objects.equals(this.name, resourceType.name);
    }
}

