/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;

class ApplicationShutdownHooks {
    private static IdentityHashMap<Thread, Thread> hooks;

    private ApplicationShutdownHooks() {
    }

    static synchronized void add(Thread thread) {
        if (hooks == null) {
            throw new IllegalStateException("Shutdown in progress");
        }
        if (thread.isAlive()) {
            throw new IllegalArgumentException("Hook already running");
        }
        if (hooks.containsKey(thread)) {
            throw new IllegalArgumentException("Hook previously registered");
        }
        hooks.put(thread, thread);
    }

    static synchronized boolean remove(Thread thread) {
        if (hooks == null) {
            throw new IllegalStateException("Shutdown in progress");
        }
        if (thread == null) {
            throw new NullPointerException();
        }
        return hooks.remove(thread) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runHooks() {
        Iterator iterator = ApplicationShutdownHooks.class;
        synchronized (ApplicationShutdownHooks.class) {
            Set<Thread> set = hooks.keySet();
            hooks = null;
            // ** MonitorExit[var1] (shouldn't be in output)
            for (Thread thread : set) {
                thread.start();
            }
            block6: for (Thread thread : set) {
                while (true) {
                    try {
                        thread.join();
                        continue block6;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            return;
        }
    }

    static {
        try {
            Shutdown.add(1, false, new Runnable(){

                @Override
                public void run() {
                    ApplicationShutdownHooks.runHooks();
                }
            });
            hooks = new IdentityHashMap();
        }
        catch (IllegalStateException illegalStateException) {
            hooks = null;
        }
    }
}

