/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.utils;

import com.sun.org.apache.xml.internal.dtm.ref.DTMNodeProxy;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class DOM2Helper {
    private DOM2Helper() {
    }

    public static String getLocalNameOfNode(Node n) {
        String name = n.getLocalName();
        return null == name ? DOM2Helper.getLocalNameOfNodeFallback(n) : name;
    }

    private static String getLocalNameOfNodeFallback(Node n) {
        String qname = n.getNodeName();
        int index = qname.indexOf(58);
        return index < 0 ? qname : qname.substring(index + 1);
    }

    public static String getNamespaceOfNode(Node n) {
        return n.getNamespaceURI();
    }

    public static boolean isNodeAfter(Node node1, Node node2) {
        Node parent2;
        if (node1 == node2 || DOM2Helper.isNodeTheSame(node1, node2)) {
            return true;
        }
        boolean isNodeAfter = true;
        Node parent1 = DOM2Helper.getParentOfNode(node1);
        if (parent1 == (parent2 = DOM2Helper.getParentOfNode(node2)) || DOM2Helper.isNodeTheSame(parent1, parent2)) {
            if (null != parent1) {
                isNodeAfter = DOM2Helper.isNodeAfterSibling(parent1, node1, node2);
            }
        } else {
            int i;
            int adjust;
            int nParents1 = 2;
            int nParents2 = 2;
            while (parent1 != null) {
                ++nParents1;
                parent1 = DOM2Helper.getParentOfNode(parent1);
            }
            while (parent2 != null) {
                ++nParents2;
                parent2 = DOM2Helper.getParentOfNode(parent2);
            }
            Node startNode1 = node1;
            Node startNode2 = node2;
            if (nParents1 < nParents2) {
                adjust = nParents2 - nParents1;
                for (i = 0; i < adjust; ++i) {
                    startNode2 = DOM2Helper.getParentOfNode(startNode2);
                }
            } else if (nParents1 > nParents2) {
                adjust = nParents1 - nParents2;
                for (i = 0; i < adjust; ++i) {
                    startNode1 = DOM2Helper.getParentOfNode(startNode1);
                }
            }
            Node prevChild1 = null;
            Node prevChild2 = null;
            while (null != startNode1) {
                if (startNode1 == startNode2 || DOM2Helper.isNodeTheSame(startNode1, startNode2)) {
                    if (null == prevChild1) {
                        isNodeAfter = nParents1 < nParents2;
                        break;
                    }
                    isNodeAfter = DOM2Helper.isNodeAfterSibling(startNode1, prevChild1, prevChild2);
                    break;
                }
                prevChild1 = startNode1;
                startNode1 = DOM2Helper.getParentOfNode(startNode1);
                prevChild2 = startNode2;
                startNode2 = DOM2Helper.getParentOfNode(startNode2);
            }
        }
        return isNodeAfter;
    }

    public static boolean isNodeTheSame(Node node1, Node node2) {
        if (node1 instanceof DTMNodeProxy && node2 instanceof DTMNodeProxy) {
            return ((DTMNodeProxy)node1).equals((DTMNodeProxy)node2);
        }
        return node1 == node2;
    }

    public static Node getParentOfNode(Node node) {
        Node parent = node.getParentNode();
        if (parent == null && 2 == node.getNodeType()) {
            parent = ((Attr)node).getOwnerElement();
        }
        return parent;
    }

    private static boolean isNodeAfterSibling(Node parent, Node child1, Node child2) {
        boolean isNodeAfterSibling = false;
        short child1type = child1.getNodeType();
        short child2type = child2.getNodeType();
        if (2 != child1type && 2 == child2type) {
            isNodeAfterSibling = false;
        } else if (2 == child1type && 2 != child2type) {
            isNodeAfterSibling = true;
        } else if (2 == child1type) {
            NamedNodeMap children = parent.getAttributes();
            int nNodes = children.getLength();
            boolean found1 = false;
            boolean found2 = false;
            for (int i = 0; i < nNodes; ++i) {
                Node child = children.item(i);
                if (child1 == child || DOM2Helper.isNodeTheSame(child1, child)) {
                    if (found2) {
                        isNodeAfterSibling = false;
                        break;
                    }
                    found1 = true;
                    continue;
                }
                if (child2 != child && !DOM2Helper.isNodeTheSame(child2, child)) continue;
                if (found1) {
                    isNodeAfterSibling = true;
                    break;
                }
                found2 = true;
            }
        } else {
            boolean found1 = false;
            boolean found2 = false;
            for (Node child = parent.getFirstChild(); null != child; child = child.getNextSibling()) {
                if (child1 == child || DOM2Helper.isNodeTheSame(child1, child)) {
                    if (found2) {
                        isNodeAfterSibling = false;
                        break;
                    }
                    found1 = true;
                    continue;
                }
                if (child2 != child && !DOM2Helper.isNodeTheSame(child2, child)) continue;
                if (found1) {
                    isNodeAfterSibling = true;
                    break;
                }
                found2 = true;
            }
        }
        return isNodeAfterSibling;
    }
}

