/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.KeyInfoContent;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.DSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.RSAKeyValue;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyValue
extends SignatureElementProxy
implements KeyInfoContent {
    public KeyValue(Document document, DSAKeyValue dSAKeyValue) {
        super(document);
        XMLUtils.addReturnToElement(this.constructionElement);
        this.constructionElement.appendChild(dSAKeyValue.getElement());
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public KeyValue(Document document, RSAKeyValue rSAKeyValue) {
        super(document);
        XMLUtils.addReturnToElement(this.constructionElement);
        this.constructionElement.appendChild(rSAKeyValue.getElement());
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public KeyValue(Document document, Element element) {
        super(document);
        XMLUtils.addReturnToElement(this.constructionElement);
        this.constructionElement.appendChild(element);
        XMLUtils.addReturnToElement(this.constructionElement);
    }

    public KeyValue(Document document, PublicKey publicKey) {
        super(document);
        XMLUtils.addReturnToElement(this.constructionElement);
        if (publicKey instanceof DSAPublicKey) {
            DSAKeyValue dSAKeyValue = new DSAKeyValue(this.doc, publicKey);
            this.constructionElement.appendChild(dSAKeyValue.getElement());
            XMLUtils.addReturnToElement(this.constructionElement);
        } else if (publicKey instanceof RSAPublicKey) {
            RSAKeyValue rSAKeyValue = new RSAKeyValue(this.doc, publicKey);
            this.constructionElement.appendChild(rSAKeyValue.getElement());
            XMLUtils.addReturnToElement(this.constructionElement);
        }
    }

    public KeyValue(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public PublicKey getPublicKey() throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.constructionElement.getFirstChild(), "RSAKeyValue", 0);
        if (element != null) {
            RSAKeyValue rSAKeyValue = new RSAKeyValue(element, this.baseURI);
            return rSAKeyValue.getPublicKey();
        }
        Element element2 = XMLUtils.selectDsNode(this.constructionElement.getFirstChild(), "DSAKeyValue", 0);
        if (element2 != null) {
            DSAKeyValue dSAKeyValue = new DSAKeyValue(element2, this.baseURI);
            return dSAKeyValue.getPublicKey();
        }
        return null;
    }

    @Override
    public String getBaseLocalName() {
        return "KeyValue";
    }
}

