/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qteslarnd1;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.MessageSigner;
import org.bouncycastle.pqc.crypto.qteslarnd1.QTESLA;
import org.bouncycastle.pqc.crypto.qteslarnd1.QTESLAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.qteslarnd1.QTESLAPublicKeyParameters;
import org.bouncycastle.pqc.crypto.qteslarnd1.QTESLASecurityCategory;

public class QTESLASigner
implements MessageSigner {
    private QTESLAPublicKeyParameters publicKey;
    private QTESLAPrivateKeyParameters privateKey;
    private SecureRandom secureRandom;

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                this.secureRandom = ((ParametersWithRandom)cipherParameters).getRandom();
                this.privateKey = (QTESLAPrivateKeyParameters)((ParametersWithRandom)cipherParameters).getParameters();
            } else {
                this.secureRandom = CryptoServicesRegistrar.getSecureRandom();
                this.privateKey = (QTESLAPrivateKeyParameters)cipherParameters;
            }
            this.publicKey = null;
            QTESLASecurityCategory.validate(this.privateKey.getSecurityCategory());
        } else {
            this.privateKey = null;
            this.publicKey = (QTESLAPublicKeyParameters)cipherParameters;
            QTESLASecurityCategory.validate(this.publicKey.getSecurityCategory());
        }
    }

    public byte[] generateSignature(byte[] byArray) {
        byte[] byArray2 = new byte[QTESLASecurityCategory.getSignatureSize(this.privateKey.getSecurityCategory())];
        switch (this.privateKey.getSecurityCategory()) {
            case 0: {
                QTESLA.signingI(byArray2, byArray, 0, byArray.length, this.privateKey.getSecret(), this.secureRandom);
                break;
            }
            case 1: {
                QTESLA.signingIIISize(byArray2, byArray, 0, byArray.length, this.privateKey.getSecret(), this.secureRandom);
                break;
            }
            case 2: {
                QTESLA.signingIIISpeed(byArray2, byArray, 0, byArray.length, this.privateKey.getSecret(), this.secureRandom);
                break;
            }
            case 3: {
                QTESLA.signingIP(byArray2, byArray, 0, byArray.length, this.privateKey.getSecret(), this.secureRandom);
                break;
            }
            case 4: {
                QTESLA.signingIIIP(byArray2, byArray, 0, byArray.length, this.privateKey.getSecret(), this.secureRandom);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown security category: " + this.privateKey.getSecurityCategory());
            }
        }
        return byArray2;
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        int n;
        switch (this.publicKey.getSecurityCategory()) {
            case 0: {
                n = QTESLA.verifyingI(byArray, byArray2, 0, byArray2.length, this.publicKey.getPublicData());
                break;
            }
            case 1: {
                n = QTESLA.verifyingIIISize(byArray, byArray2, 0, byArray2.length, this.publicKey.getPublicData());
                break;
            }
            case 2: {
                n = QTESLA.verifyingIIISpeed(byArray, byArray2, 0, byArray2.length, this.publicKey.getPublicData());
                break;
            }
            case 3: {
                n = QTESLA.verifyingPI(byArray, byArray2, 0, byArray2.length, this.publicKey.getPublicData());
                break;
            }
            case 4: {
                n = QTESLA.verifyingPIII(byArray, byArray2, 0, byArray2.length, this.publicKey.getPublicData());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown security category: " + this.publicKey.getSecurityCategory());
            }
        }
        return 0 == n;
    }
}

