/*
 * Decompiled with CFR 0.152.
 */
package com.janus.easyqrinvoice;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class LoggingFormatter
extends Formatter {
    @Override
    public String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(logRecord.getMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        stringBuffer.append(simpleDateFormat.format(gregorianCalendar.getTime()));
        stringBuffer.append(": ");
        stringBuffer.append(logRecord.getLevel());
        stringBuffer.append("\t - \t");
        stringBuffer.append(logRecord.getLoggerName());
        stringBuffer.append("\t - \t");
        stringBuffer.append(this.formatMessage(logRecord));
        if (logRecord.getThrown() != null) {
            stringBuffer.append("\t - \t");
            stringBuffer.append(this.getStackTrace(logRecord.getThrown()));
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    @Override
    public String getHead(Handler handler) {
        return super.getHead(handler);
    }

    @Override
    public String getTail(Handler handler) {
        return super.getTail(handler);
    }
}

