/*
 * Decompiled with CFR 0.152.
 */
package com.janus.easyqrinvoice;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.EnumMap;
import java.util.logging.Logger;

public class EPC_QRCodeGenerator {
    private static final Logger logger = Logger.getLogger(EPC_QRCodeGenerator.class.getName());

    public BufferedImage generateQRCode(String string, int n) throws WriterException {
        EnumMap<EncodeHintType, Object> enumMap = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        enumMap.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        enumMap.put(EncodeHintType.MARGIN, Integer.valueOf(1));
        enumMap.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.M);
        QRCodeWriter qRCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qRCodeWriter.encode(string, BarcodeFormat.QR_CODE, n, n, enumMap);
        int n2 = bitMatrix.getWidth();
        BufferedImage bufferedImage = new BufferedImage(n2, n2, 1);
        bufferedImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, n2, n2);
        graphics2D.setColor(Color.BLACK);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (!bitMatrix.get(i, j)) continue;
                graphics2D.fillRect(i, j, 1, 1);
            }
        }
        logger.info("QRCode generated.");
        return bufferedImage;
    }
}

