/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.jvm;

import com.sun.deploy.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CircularByteBuffer {
    private static final boolean DEBUG = false;
    private byte[] buf;
    private int iRead = 0;
    private int iWrite = 0;
    private int lenRead = 0;

    public CircularByteBuffer(int n) {
        this.buf = new byte[n];
    }

    private synchronized void updateAvailableReadLength(boolean bl) {
        this.lenRead = this.iWrite == this.iRead ? (bl ? this.buf.length : 0) : (this.iWrite > this.iRead ? this.iWrite - this.iRead : this.buf.length - this.iRead + this.iWrite);
    }

    private synchronized int availableToWrite() {
        return this.buf.length - this.lenRead;
    }

    private synchronized int availableToRead() {
        return this.lenRead;
    }

    private synchronized void truncateRead(int n) {
        this.iRead = this.iRead + n >= this.buf.length ? this.iRead + n - this.buf.length : (this.iRead += n);
    }

    public synchronized void write(byte[] byArray, int n) throws IOException {
        int n2;
        if (n > byArray.length) {
            n = byArray.length;
        }
        if (n == 0) {
            return;
        }
        int n3 = this.iWrite;
        int n4 = this.availableToWrite();
        int n5 = 0;
        if (n >= this.buf.length) {
            n5 = n - this.buf.length;
            n = this.buf.length;
            this.iWrite = this.iRead;
        } else {
            if (n > n4) {
                n2 = n - n4;
                this.truncateRead(n2);
            }
            this.iWrite = (this.iWrite + n) % this.buf.length;
        }
        this.updateAvailableReadLength(true);
        if (n3 + n <= this.buf.length) {
            System.arraycopy(byArray, n5, this.buf, n3, n);
        } else {
            n2 = this.buf.length - n3;
            int n6 = n - n2;
            System.arraycopy(byArray, n5, this.buf, n3, n2);
            System.arraycopy(byArray, n5 + n2, this.buf, 0, n6);
        }
    }

    public synchronized byte[] chunkRead(int n) {
        int n2 = this.availableToRead();
        if (n2 > n) {
            n2 = n;
        }
        byte[] byArray = new byte[n2];
        if (this.iRead + n2 <= this.buf.length) {
            System.arraycopy(this.buf, this.iRead, byArray, 0, n2);
            this.iRead += n2;
        } else {
            int n3 = this.buf.length - this.iRead;
            int n4 = this.iRead + n2 - this.buf.length;
            System.arraycopy(this.buf, this.iRead, byArray, 0, n3);
            System.arraycopy(this.buf, 0, byArray, n3, n4);
            this.iRead = n4;
        }
        this.updateAvailableReadLength(false);
        return byArray;
    }

    public static class Streamer
    implements Runnable {
        private static final int BUFSIZE = 4096;
        private final InputStream in;
        private final CircularByteBuffer buf;
        private final int readSize;
        private boolean done = false;
        private boolean running = false;
        private boolean pauseForConsumer = false;

        public Streamer(InputStream inputStream) {
            this(inputStream, inputStream instanceof ByteArrayInputStream);
        }

        public Streamer(InputStream inputStream, boolean bl) {
            this(inputStream, 8192, 4096, bl);
        }

        public Streamer(InputStream inputStream, int n, int n2, boolean bl) {
            this.in = inputStream;
            this.buf = new CircularByteBuffer(n);
            this.readSize = n2;
            this.pauseForConsumer = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] byArray = new byte[this.readSize];
            try {
                try {
                    Streamer streamer = this;
                    synchronized (streamer) {
                        this.running = true;
                    }
                    while (!this.done) {
                        int n;
                        if (this.pauseForConsumer) {
                            this.waitForReader();
                        }
                        if ((n = this.in.read(byArray)) < 0) break;
                        this.buf.write(byArray, n);
                    }
                    Object var5_6 = null;
                    this.done = true;
                }
                catch (IOException iOException) {
                    Trace.ignored((Throwable)iOException);
                    Object var5_7 = null;
                    this.done = true;
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.done = true;
                throw throwable;
            }
        }

        private boolean waitForRunning() {
            while (!this.running) {
                try {
                    this.wait(10L);
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] readAvailable() {
            Object object = this;
            synchronized (object) {
                if (!this.waitForRunning()) {
                    return new byte[0];
                }
            }
            object = this.buf.chunkRead(this.readSize);
            if (this.pauseForConsumer) {
                Streamer streamer = this;
                synchronized (streamer) {
                    this.notifyAll();
                }
            }
            if (this.done && (object == null || ((Object)object).length == 0)) {
                return null;
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForReader() {
            while (this.buf.availableToWrite() < this.readSize) {
                Streamer streamer = this;
                synchronized (streamer) {
                    try {
                        this.wait(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

