/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.gluegen.runtime;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class StructAccessor {
    private ByteBuffer bb;
    private CharBuffer cb;
    private DoubleBuffer db;
    private FloatBuffer fb;
    private IntBuffer ib;
    private LongBuffer lb;
    private ShortBuffer sb;

    public StructAccessor(ByteBuffer byteBuffer) {
        this.bb = byteBuffer.order(ByteOrder.nativeOrder());
    }

    public ByteBuffer getBuffer() {
        return this.bb;
    }

    public ByteBuffer slice(int n, int n2) {
        this.bb.position(n);
        this.bb.limit(n + n2);
        ByteBuffer byteBuffer = this.bb.slice();
        this.bb.position(0);
        this.bb.limit(this.bb.capacity());
        return byteBuffer;
    }

    public byte getByteAt(int n) {
        return this.bb.get(n);
    }

    public void setByteAt(int n, byte by) {
        this.bb.put(n, by);
    }

    public char getCharAt(int n) {
        return this.charBuffer().get(n);
    }

    public void setCharAt(int n, char c) {
        this.charBuffer().put(n, c);
    }

    public double getDoubleAt(int n) {
        return this.doubleBuffer().get(n);
    }

    public void setDoubleAt(int n, double d) {
        this.doubleBuffer().put(n, d);
    }

    public float getFloatAt(int n) {
        return this.floatBuffer().get(n);
    }

    public void setFloatAt(int n, float f) {
        this.floatBuffer().put(n, f);
    }

    public int getIntAt(int n) {
        return this.intBuffer().get(n);
    }

    public void setIntAt(int n, int n2) {
        this.intBuffer().put(n, n2);
    }

    public long getLongAt(int n) {
        return this.longBuffer().get(n);
    }

    public void setLongAt(int n, long l) {
        this.longBuffer().put(n, l);
    }

    public short getShortAt(int n) {
        return this.shortBuffer().get(n);
    }

    public void setShortAt(int n, short s) {
        this.shortBuffer().put(n, s);
    }

    private CharBuffer charBuffer() {
        if (this.cb == null) {
            this.cb = this.bb.asCharBuffer();
        }
        return this.cb;
    }

    private DoubleBuffer doubleBuffer() {
        if (this.db == null) {
            this.db = this.bb.asDoubleBuffer();
        }
        return this.db;
    }

    private FloatBuffer floatBuffer() {
        if (this.fb == null) {
            this.fb = this.bb.asFloatBuffer();
        }
        return this.fb;
    }

    private IntBuffer intBuffer() {
        if (this.ib == null) {
            this.ib = this.bb.asIntBuffer();
        }
        return this.ib;
    }

    private LongBuffer longBuffer() {
        if (this.lb == null) {
            this.lb = this.bb.asLongBuffer();
        }
        return this.lb;
    }

    private ShortBuffer shortBuffer() {
        if (this.sb == null) {
            this.sb = this.bb.asShortBuffer();
        }
        return this.sb;
    }
}

