/*
 * Decompiled with CFR 0.152.
 */
package com.janus.easyqrinvoice.validator;

import com.janus.easyqrinvoice.gui.ApplicationContext;
import com.janus.easyqrinvoice.validator.IBANValidator;
import com.janus.easyqrinvoice.validator.ValidationException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;

public class EasyQRInvoiceValidator {
    public static void validateKontoinhaber(String string) throws ValidationException {
        String string2 = "([\u00e4\u00c4\u00f6\u00d6\u00fc\u00dc\u00df&*%$ \\-':?,+()/\\.a-zA-Z0-9])*";
        if (string == null || string.replace(" ", "").isEmpty() || string.length() > 70 || !string.matches(string2)) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.kontoinhaber.notvalid.user.msg"), string);
        }
    }

    public static void validateIBAN(String string) throws ValidationException {
        if (string == null || !string.replace(" ", "").matches("[a-zA-Z]{2}[0-9]{2}[a-zA-Z0-9]{11}([a-zA-Z0-9]?){0,19}") || !IBANValidator.validate(string.replace(" ", ""))) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.iban.notvalid.user.msg"), string);
        }
    }

    public static void validateBIC(String string) throws ValidationException {
        if (string == null || !string.replace(" ", "").matches("([a-zA-Z]{6,6}[a-zA-Z2-9][a-nA-Np-zP-Z0-9]([a-zA-Z0-9]{3,3}){0,1})")) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.bic.notvalid.user.msg"), string);
        }
    }

    public static void validateVerwendungszweck(String string) throws ValidationException {
        String string2 = "([\u00e4\u00c4\u00f6\u00d6\u00fc\u00dc\u00df&*%$ \\-':?,+()/\\.a-zA-Z0-9])*";
        if (string == null || string.replace(" ", "").isEmpty() || string.trim().length() > 140 || !string.matches(string2)) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.verwendungszweck.user.msg"), string);
        }
    }

    public static void validateAmount(String string) throws ValidationException {
        BigDecimal bigDecimal;
        try {
            DecimalFormat decimalFormat = new DecimalFormat("#0.00");
            decimalFormat.setParseBigDecimal(true);
            bigDecimal = (BigDecimal)decimalFormat.parse(string);
        }
        catch (NumberFormatException | ParseException exception) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.amount.user.msg"), string);
        }
        if (bigDecimal.compareTo(new BigDecimal(0)) != 1) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.amount.greaterzero.user.msg"), bigDecimal);
        }
        if (bigDecimal.scale() > 2) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.amount.scale.user.msg"), bigDecimal);
        }
    }

    public static void validateText(String string) throws ValidationException {
        if (string == null || string.replace(" ", "").isEmpty() || string.length() > 140) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.text.notvalid.user.msg"), string);
        }
    }

    public static void validatePosition(String string) throws ValidationException {
        Integer n;
        try {
            n = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.position.user.msg"), string);
        }
        if (n < 0) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.position.greaterzero.user.msg"), n);
        }
    }
}

